#include "url_decode.h"

#include <passport/infra/libs/cpp/auth_core/sessionutils.h>

#include <cctype>

namespace NPassport::NLast {
    inline char Hexval(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - '0';
        }
        char c = tolower(ch);
        if (c >= 'a' && c <= 'f') {
            return c - 'a' + 10;
        }
        return 0;
    }

    TString HexDecode(const TString& s) {
        TString ret;
        ret.reserve(s.size());

        enum EDecoderState {
            Regular,
            BSlash,
            X,
            First_Digit,
        };

        char h1 = 0;
        EDecoderState state = Regular;
        for (const char ch : s) {
            switch (state) {
                case BSlash:
                    if (ch == 'x') {
                        state = X;
                    } else {
                        state = Regular;
                        ret.push_back('\\');
                        ret.push_back(ch);
                    }
                    break;
                case X:
                    if (std::isxdigit(ch)) {
                        state = First_Digit;
                        h1 = ch;
                    } else {
                        state = Regular;
                        ret.push_back('\\');
                        ret.push_back('x');
                        ret.push_back(ch);
                    }
                    break;
                case First_Digit:
                    state = Regular;
                    if (std::isxdigit(ch)) {
                        ret.push_back(Hexval(h1) * 16 + Hexval(ch));
                    } else {
                        ret.push_back('\\');
                        ret.push_back('x');
                        ret.push_back(h1);
                        ret.push_back(ch);
                    }
                    break;
                default: // Regular
                    if (ch == '\\') {
                        state = BSlash;
                    } else {
                        ret.push_back(ch);
                    }
                    break;
            }
        }

        return ret;
    }
}
