#include "worker.h"

#include <passport/infra/libs/cpp/utils/string/string_utils.h>

namespace NPassport::NLast {
    TWorker::TWorker(TWorkTasks& tasks, TWorkResults& results)
        : Stoping_(false)
        , Tasks_(tasks)
        , Results_(results)
        , Thread_([this]()
                  {
                      while (!Stoping_.load(std::memory_order_relaxed)) {
                          try {
                              TTestContext curCtx;
                              while (!Tasks_.Dequeue(&curCtx)) {
                                  std::this_thread::sleep_for(std::chrono::milliseconds(50));
                                  if (Stoping_.load(std::memory_order_relaxed)) {
                                      return;
                                  }
                              }
                              if (Stoping_.load(std::memory_order_relaxed)) {
                                  return;
                              }

                              // Must be here because of time points in cookies
                              for (const auto& var : curCtx.Vars) {
                                  var->Apply(curCtx);
                              }
                              TSigner::Sign(curCtx);
                              //

                              TPerformResult perfRes = PerformRequest(curCtx);
                              TCheckProcessor check(curCtx, perfRes);

                              TString output;
                              bool res = check.Process(output);

                              Results_.Enqueue({std::move(curCtx),
                                                std::move(perfRes),
                                                std::move(output),
                                                res});
                          } catch (const std::exception& e) {
                              Cout << "Worker exception: " << e.what() << Endl;
                              exit(1);
                          }
                      }
                  })
    {
    }

    TWorker::~TWorker() {
        Stop();
        if (Thread_.joinable()) {
            Thread_.join();
        }
    }

    void TWorker::Stop() {
        Stoping_.store(true);
    }

    TPerformResult TWorker::PerformRequest(const TTestContext& curCtx) {
        ui32 tries = 3;
        for (ui32 idx = 0; idx < tries - 1; ++idx) {
            try {
                TPerformResult res = Conn_.Perform(curCtx);
                Y_ENSURE(res.HttpCode < 500,
                         "Bad response (" << res.HttpCode << ").\n"
                                          << res.Output);
                return res;
            } catch (const std::exception& e) {
                Cerr << NUtils::CreateStr(
                    "Failed to perform http request. ",
                    "Attempt #", idx + 1,
                    ": ", e.what(), "\n");
                Cerr.Flush();
            }
        }

        // show last request
        return Conn_.Perform(curCtx);
    }

    TWorkerPool::TWorkerPool(size_t count) {
        for (size_t idx = 0; idx < count; ++idx) {
            Workers_.push_back(std::make_unique<TWorker>(Tasks_, Results_));
        }
    }

    TWorkerPool::~TWorkerPool() {
        for (auto& w : Workers_) {
            w->Stop();
        }
    }

    void TWorkerPool::Resize(size_t size) {
        while (Workers_.size() > size) {
            Workers_.pop_back();
        }
        while (Workers_.size() < size) {
            Workers_.push_back(std::make_unique<TWorker>(Tasks_, Results_));
        }
    }

    void TWorkerPool::AddTask(TTestContext&& ctx) {
        Tasks_.Enqueue(std::move(ctx));
    }

    bool TWorkerPool::GetNext(TWorkerResult& out) {
        return Results_.Dequeue(&out);
    }

}
