#pragma once

#include "check_processor.h"
#include "connection.h"
#include "func.h"
#include "variables.h"

#include <util/generic/string.h>
#include <util/thread/lfqueue.h>

#include <atomic>
#include <thread>

namespace NPassport::NLast {
    struct TWorkerResult {
        TTestContext Ctx;
        TPerformResult Perf;
        TString Output;
        bool Res = false;
    };
    using TWorkTasks = TLockFreeQueue<TTestContext>;
    using TWorkResults = TLockFreeQueue<TWorkerResult>;

    class TWorker {
    public:
        TWorker(TWorkTasks& tasks, TWorkResults& results);
        ~TWorker();

        void Stop();

    private:
        TPerformResult PerformRequest(const TTestContext& curCtx);

    private:
        TConnection Conn_;
        std::atomic_bool Stoping_;

        TWorkTasks& Tasks_;
        TWorkResults& Results_;
        std::thread Thread_;
    };

    class TWorkerPool {
    public:
        TWorkerPool(size_t count);
        ~TWorkerPool();

        void Resize(size_t size);

        void AddTask(TTestContext&& ctx);
        bool GetNext(TWorkerResult& out);

    private:
        TLockFreeQueue<TTestContext> Tasks_;
        TLockFreeQueue<TWorkerResult> Results_;
        std::vector<std::unique_ptr<TWorker>> Workers_;
    };

}
