PROGRAM()

OWNER(g:passport_infra)

PEERDIR(
    contrib/libs/curl
    contrib/libs/openssl
    library/cpp/getopt/small
    library/cpp/http/simple
    library/cpp/tvmauth
    passport/infra/daemons/sezamapi/src/utils
    passport/infra/libs/cpp/auth_core
    passport/infra/libs/cpp/xml
    passport/infra/libs/cpp/dbpool
    passport/infra/libs/cpp/tvm/common
    passport/infra/libs/cpp/tvm/logger
    passport/infra/libs/cpp/tvm/signer
    passport/infra/libs/cpp/utils
    passport/infra/libs/cpp/yp_cookie_parser
)

SRCS(
    src/check_processor.cpp
    src/checks/check_expires_time.cpp
    src/checks/check_ignore.cpp
    src/checks/check_json_point.cpp
    src/checks/check_match_regex.cpp
    src/checks/check_match_xpath.cpp
    src/checks/check_oauth_token.cpp
    src/checks/check_service_ticket.cpp
    src/checks/check_sess_guard.cpp
    src/checks/check_sessionid.cpp
    src/checks/check_tvm_public_keys.cpp
    src/checks/check_unixtime.cpp
    src/checks/check_user_ticket.cpp
    src/checks/check_yes.cpp
    src/checks/check_yp.cpp
    src/checks/common.cpp
    src/checks/facade.cpp
    src/config.cpp
    src/connection.cpp
    src/context/lah_context.cpp
    src/context/oauth_context.cpp
    src/context/sess_context.cpp
    src/context/ticket_context.cpp
    src/engine.cpp
    src/func.cpp
    src/generators/facade.cpp
    src/generators/gen_lah.cpp
    src/generators/gen_oauth_token.cpp
    src/generators/gen_service_ticket.cpp
    src/generators/gen_sess_guard.cpp
    src/generators/gen_sessionid.cpp
    src/generators/gen_unixtime.cpp
    src/generators/gen_user_ticket.cpp
    src/generators/gen_yp.cpp
    src/libretto.cpp
    src/main.cpp
    src/pregeneration.cpp
    src/print.cpp
    src/result.cpp
    src/scenario.cpp
    src/utils/regex_escape.cpp
    src/utils/session_utils.cpp
    src/utils/sqspace.cpp
    src/utils/url_decode.cpp
    src/variables.cpp
    src/worker.cpp
)

END()

RECURSE_FOR_TESTS(
    ut
)
