package config

import (
	"os"

	"a.yandex-team.ru/library/go/core/xerrors"
)

type Config struct {
	OAuthToken string
	Cluster    string
}

var ytTokenEnv = "YT_TOKEN"
var ytClusterEnv = "YT_CLUSTER"

func DefaultConfig() *Config {
	cfg := &Config{
		OAuthToken: os.Getenv(ytTokenEnv),
		Cluster:    os.Getenv(ytClusterEnv),
	}

	return cfg
}

func (cfg *Config) Check() error {
	if cfg.OAuthToken == "" {
		return xerrors.Errorf("failed to get token from env %s", ytTokenEnv)
	}
	if cfg.Cluster == "" {
		return xerrors.Errorf("failed to get cluster from env %s", ytClusterEnv)
	}
	return nil
}
