package modes

import (
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/passport/infra/tools/ytbench/internal/config"
	"a.yandex-team.ru/passport/infra/tools/ytbench/internal/modes/selectrows"
)

func Execute() error {
	cfg := config.DefaultConfig()

	rootCmd := cobra.Command{
		Use: "ytbench",
		PersistentPreRunE: func(cmd *cobra.Command, args []string) error {
			return cfg.Check()
		},
		Short: "This tool allowes to run some benchmarks over YT",
	}
	rootCmd.AddCommand(selectrows.Cmd(cfg))

	rootCmd.AddCommand(&cobra.Command{
		Use:   "bash_completion",
		Short: "Generates bash completion scripts",
		Long: `Add to your ~/.bashrc line and restart your bash:
source <(ytbench bash_completion)
`,
		Run: func(cmd *cobra.Command, args []string) {
			_ = rootCmd.GenBashCompletion(os.Stdout)
		},
	})

	rootCmd.SilenceUsage = true
	return rootCmd.Execute()
}
