package selectrows

import (
	"io/ioutil"

	"github.com/spf13/cobra"
	"golang.org/x/xerrors"

	"a.yandex-team.ru/passport/infra/libs/go/cliflags"
	"a.yandex-team.ru/passport/infra/tools/ytbench/internal/config"
)

func Cmd(cfg *config.Config) *cobra.Command {
	var prms params
	var queryPath string

	res := &cobra.Command{
		Use:     "select-rows",
		Short:   "",
		Example: "ytbench select-rows --query ./some.query",
		RunE: func(cmd *cobra.Command, args []string) error {
			if prms.threads == 0 {
				return xerrors.Errorf("threads count cannot be == 0")
			}

			query, err := ioutil.ReadFile(queryPath)
			if err != nil {
				return xerrors.Errorf("failed to get query from file: %s", err)
			}
			prms.query = string(query)

			return run(cfg, &prms)
		},
	}

	flags := res.Flags()
	flags.Uint32Var(&prms.threads, "threads", 16, "threads")
	flags.Uint32Var(&prms.duration, "durations", 10, "duration")
	flags.StringVar(&queryPath, "query", "", "path to file with query")

	cliflags.MarkRequired(flags, "query")

	return res
}
