package blackbox

import (
	"context"

	"a.yandex-team.ru/library/go/yandex/blackbox/httpbb/bbtypes"
)

type GetMaxUIDResponse struct {
	bbtypes.BaseResponse
	MaxUID    uint64 `json:"max_uid"`
	MaxPDDUID uint64 `json:"max_pdd_uid"`
}

func (c *blackboxClient) GetMaxUID(ctx context.Context) (*GetMaxUIDResponse, error) {
	httpReq := c.InternalHTTP().R(ctx).SetQueryParams(map[string]string{
		"method": "get_max_uid",
		"format": "json",
	})

	var rsp GetMaxUIDResponse
	if err := c.InternalHTTP().Get(httpReq, &rsp); err != nil {
		return nil, err
	}

	return &rsp, nil
}
