package blackbox

import (
	"context"

	"a.yandex-team.ru/library/go/yandex/blackbox"
	"a.yandex-team.ru/library/go/yandex/blackbox/httpbb"
)

var _ blackbox.Client = (*blackboxClient)(nil)
var _ Client = (*blackboxClient)(nil)

type blackboxClient struct {
	*httpbb.Client
}

type Client interface {
	blackbox.Client

	FindPddAccounts(ctx context.Context, domainID uint64, offset uint64, limit uint64, sortParams FindPddAccountsSort) (*FindPddAccountsResponse, error)
	GetMaxUID(ctx context.Context) (*GetMaxUIDResponse, error)
	HostedDomains(ctx context.Context, domainID uint64) (*HostedDomainsResponse, error)
}
