package httpdaemon

import (
	"context"
	"fmt"
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/passport/shared/golibs/logger"
)

type httpCommonConfig struct {
	Address string `json:"listen_address"`
	Port    uint16 `json:"port"`
}

type httpsCommonConfig struct {
	Address string `json:"listen_address"`
	Port    uint16 `json:"port"`
	Cert    string `json:"cert"`
	Key     string `json:"key"`
}

type httpState struct {
	echo *echo.Echo
	addr string
}

func startCommonHTTP(cfg *httpCommonConfig, stopper chan<- bool, echo *echo.Echo) (*httpState, error) {
	state := &httpState{
		echo: echo,
		addr: fmt.Sprintf("%s:%d", cfg.Address, cfg.Port),
	}

	go func() {
		logger.Log().Infof("Http server (common) started: '%s'", state.addr)
		err := echo.Start(state.addr)

		if err != nil && err != http.ErrServerClosed {
			logger.Log().Errorf("Http server (common) stopped: %s", err)
			stopper <- true
		}
	}()

	return state, nil
}

func startCommonHTTPS(cfg *httpsCommonConfig, stopper chan<- bool, echo *echo.Echo) (*httpState, error) {
	state := &httpState{
		echo: echo,
		addr: fmt.Sprintf("%s:%d", cfg.Address, cfg.Port),
	}

	go func() {
		logger.Log().Infof("Http server (common) started: '%s'", state.addr)
		err := echo.StartTLS(state.addr, cfg.Cert, cfg.Key)

		if err != nil && err != http.ErrServerClosed {
			logger.Log().Errorf("Http server (common) stopped: %s", err)
			stopper <- true
		}
	}()

	return state, nil
}

func (s *httpState) stop() {
	logger.Log().Infof("Http server stopping: '%s'", s.addr)
	if err := s.echo.Shutdown(context.Background()); err != nil {
		logger.Log().Warnf("Shutting down interface: %s", err)
	}
}
