package middlewares

import (
	"context"
	"encoding/hex"
	"math/rand"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/ctxlog"
)

const (
	KeyRequestID = "request_id"
)

func WithReqID(ctx context.Context, id string) context.Context {
	return ctxlog.WithFields(ctx, log.String(KeyRequestID, id))
}

func ContextReqID(ctx context.Context) string {
	for _, k := range ctxlog.ContextFields(ctx) {
		if k.Key() == KeyRequestID {
			return k.String()
		}
	}

	return ""
}

func ReqID() echo.MiddlewareFunc {
	return func(next echo.HandlerFunc) echo.HandlerFunc {
		return func(c echo.Context) (err error) {
			reqID := c.Request().Header.Get("X-Request-Id")
			if reqID == "" {
				random := make([]byte, 8)
				rand.Read(random)
				reqID = hex.EncodeToString(random)
			}

			c.SetRequest(c.Request().WithContext(
				WithReqID(c.Request().Context(), reqID),
			))

			return next(c)
		}
	}
}
