package middlewares

import (
	"context"
	"time"

	"github.com/labstack/echo/v4"
)

type ctxStartInsKey struct{}

var keyStartIns ctxStartInsKey

func WithStartInstant(ctx context.Context, t time.Time) context.Context {
	return context.WithValue(ctx, &keyStartIns, t)
}

func ContextStartInstant(ctx context.Context) (t time.Time) {
	t, _ = ctx.Value(&keyStartIns).(time.Time)
	return
}

func StartInstant() echo.MiddlewareFunc {
	return func(next echo.HandlerFunc) echo.HandlerFunc {
		return func(c echo.Context) (err error) {
			c.SetRequest(c.Request().WithContext(
				WithStartInstant(c.Request().Context(), time.Now()),
			))

			return next(c)
		}
	}
}
