package httpdaemon

import (
	"encoding/json"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/passport/shared/golibs/logger"
)

type ServiceConfig map[string]json.RawMessage

type Config struct {
	Log         logger.Config      `json:"logger"`
	HTTPConfig  *httpCommonConfig  `json:"http_common"`
	HTTPSConfig *httpsCommonConfig `json:"https_common"`
	HTTPUnistat *httpUnistatConfig `json:"http_unistat"`
	ServiceCfg  ServiceConfig      `json:"service"`
}

type ServiceFactory interface {
	NewService(cfg ServiceConfig) (Service, error)
}

type Service interface {
	AddHandlers(echo *echo.Echo)
}

type ServiceWithOptions interface {
	Service
	GetOptions() *Options
}

type Options struct {
	DisableSignalsByPath   bool
	ExtendedUnistatHandler func(e *echo.Echo)
	StopService            func()
}
