package httpdaemon

import (
	"encoding/json"
	"fmt"
	"os"

	flag "github.com/spf13/pflag"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/library/go/maxprocs"
)

func SimpleRun(factory ServiceFactory) {
	maxprocs.AdjustAuto()

	cfgFile := flag.StringP("config", "c", "", "config file")
	flag.Parse()

	if len(*cfgFile) == 0 {
		_, _ = fmt.Fprintln(os.Stderr, "config is required")
		flag.Usage()
		os.Exit(1)
	}

	if err := Run(*cfgFile, factory); err != nil {
		_, _ = fmt.Fprintf(os.Stderr, "Error: %s\n", err)
		os.Exit(1)
	}
}

func ParseServiceConfig(cfg ServiceConfig, out interface{}) error {
	bytes, err := json.Marshal(cfg)
	if err != nil {
		return xerrors.Errorf("failed to marshal cfg: %w", err)
	}

	return json.Unmarshal(bytes, out)
}
