package unistat

import (
	"go.uber.org/atomic"

	libunistat "a.yandex-team.ru/library/go/yandex/unistat"
)

type SignalAbsolute struct {
	metric *libunistat.Numeric
	value  *atomic.Float64
}

func (s *SignalAbsolute) Add(value float64) {
	s.value.Add(value)
	s.metric.Update(s.value.Load())
}

func (s *SignalAbsolute) Sub(value float64) {
	s.value.Sub(value)
	s.metric.Update(s.value.Load())
}

func (s *SignalAbsolute) Store(value float64) {
	s.value.Store(value)
	s.metric.Update(value)
}
