package unistat

import (
	"sort"

	"a.yandex-team.ru/library/go/core/xerrors"
	libunistat "a.yandex-team.ru/library/go/yandex/unistat"
	"a.yandex-team.ru/library/go/yandex/unistat/aggr"
)

type SignalHgram struct {
	metric *libunistat.Histogram
}

func (s *SignalHgram) Inc(key float64) {
	s.metric.Update(key)
}

func newSignalHgram(name string, bounds []float64) (*SignalHgram, error) {
	if len(bounds) == 0 {
		return nil, xerrors.Errorf("Length of bounds in Hgram cannot be == 0")
	}
	if len(bounds) > 50 {
		return nil, xerrors.Errorf("Length of bounds in Hgram cannot be > 50, got %d", len(bounds))
	}
	bounds = append(bounds, 0)
	bounds = uniqueBounds(bounds)
	sort.Slice(bounds, func(i, j int) bool { return bounds[i] < bounds[j] })

	res := &SignalHgram{
		metric: libunistat.NewHistogram(
			name,
			1,
			aggr.Histogram(),
			bounds,
		),
	}

	return res, nil
}

func uniqueBounds(bounds []float64) []float64 {
	set := map[float64]interface{}{}

	res := make([]float64, 0)
	for _, b := range bounds {
		_, ok := set[b]
		if ok {
			continue
		}

		set[b] = 0
		res = append(res, b)
	}

	return res
}
