package unistat

import (
	"sync"
)

type SignalSet struct {
	prefix string
	chunk  *Chunk
	values map[string]*SignalDiff
	mtx    sync.RWMutex
}

func (s *SignalSet) CreateSignal(key string) {
	s.CreateOrAddToSignal(key, 0)
}

func (s *SignalSet) IncSignal(key string) {
	s.AddToSignal(key, 1)
}

func (s *SignalSet) AddToSignal(key string, value float64) {
	s.addToSignal(key, value)
}

func (s *SignalSet) addToSignal(key string, value float64) bool {
	s.mtx.RLock()
	defer s.mtx.RUnlock()

	val, ok := s.values[key]
	if ok {
		val.Add(value)
		return true
	}

	return false
}

func (s *SignalSet) CreateOrIncSignal(key string) {
	s.CreateOrAddToSignal(key, 1)
}

func (s *SignalSet) CreateOrAddToSignal(key string, value float64) {
	if s.addToSignal(key, value) {
		return
	}

	s.mtx.Lock()
	defer s.mtx.Unlock()

	val, ok := s.values[key]
	if ok {
		val.Add(value)
		return
	}

	val = s.chunk.CreateSignalDiff(s.prefix + key)
	val.Add(value)
	s.values[key] = val
}

func newSignalSet(signalPrefix string, chunk *Chunk) *SignalSet {
	return &SignalSet{
		prefix: signalPrefix,
		chunk:  chunk,
		values: map[string]*SignalDiff{},
	}
}
