package unistat

import "time"

type TimeStat struct {
	hgram *SignalHgram
}

func (t *TimeStat) Insert(duration time.Duration) {
	t.hgram.Inc(float64(duration.Milliseconds()))
}

func CreateDefaultTimeBounds() []time.Duration {
	return CreateTimeBoundsFromMilliseconds(
		[]uint64{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 15, 17, 20, 25, 30, 35, 40, 45, 50, 60, 70, 80, 90, 100, 125, 150, 175, 200, 225, 250, 275, 300, 400, 500, 750, 1000, 2000, 3000})
}

func CreateTimeBoundsFromMilliseconds(bounds []uint64) []time.Duration {
	res := make([]time.Duration, 0)
	for _, d := range bounds {
		res = append(res, time.Duration(d)*time.Millisecond)
	}

	return res
}

func CreateTimeBoundsFromMaxValue(dur time.Duration) []time.Duration {
	count := 50
	step := dur / time.Duration(count)

	res := make([]time.Duration, 0)
	for idx := 0; idx < count-1; idx++ {
		res = append(res, time.Duration(idx)*step)
	}
	res = append(res, dur)

	return res
}

func newTimeStat(hgram *SignalHgram) *TimeStat {
	return &TimeStat{
		hgram: hgram,
	}
}
