package utils

import (
	"encoding/json"
	"time"
)

type Duration struct {
	time.Duration
}

func (duration Duration) MarshalJSON() ([]byte, error) {
	return []byte(`"` + duration.Duration.String() + `"`), nil
}

func (duration *Duration) UnmarshalJSON(data []byte) error {
	var raw string
	err := json.Unmarshal(data, &raw)
	if err != nil {
		return err
	}

	duration.Duration, err = time.ParseDuration(raw)
	if err != nil {
		return err
	}

	return nil
}
