# Про разработку

Все что ниже перечислено одной строкой без глубокой проработки.
Предлагаю отталкиваться от этой базы и далее ее дополнять.

## Конвенции
- Именование переменных — camelCase
- Именование файлов — kebab-case
- Использовать только именованные экспорты (исключения только для Next дге оно того требует)

## Донастроить инфру для разработки
- Prettier
- Линтеры — схема свободная
- Чекеры на прекоммит

## Инфра и тестовое окружение
Пока нет, все только локально.
Будет появляться после завоза вас в Я.

## Typescript
Все через TS и с типизацией.\
Желательно глобальные/сквозные типы вынести в глобальный неймспейс (чтобы не импортить бесконечно).

## Требования

### Используем Lego
**Все** базовые компоненты строим на основе Lego.\
Их можно/нужно кастомизировать — пример можно посмотреть в `src/client/components/button/_variant`.\
Storybook — [https://yastatic.net/s3/frontend/lego/storybook/index.html?path=/docs/guides-documentation--readme](https://yastatic.net/s3/frontend/lego/storybook/index.html?path=/docs/guides-documentation--readme)

### Стили и темы
**Темы**\
На проекте уже подключены наши внутренние темы.\
Темы лежат тут — `src/client/styles/themes`.\
Темы подключены через `themekit` — [https://github.com/bem/themekit](https://github.com/bem/themekit).

**Шрифты**\
Везде используем `YS Text`.\
Уже тоже подключено в `src/client/styles/globals.css`.

### Верстка
Всю верстку (за исключением layout'a) запирать в компонентах.\
Пример желаемой итоговой верстки
```jsx
<Panel>
  <Panel.Body>
    <Col gap="l" top="l">
      <Row gap="l">
        <Icon glyph="info" size="m" />
        <FormInput {...} />
      </Row>
      <Row gap="l">
        <FormCheckbox {...} />
      </Row>
    </Col>
    <Box top="s">
      <FormSubmit {...} />
    </Box>
  </Panel.Body>
</Panel>
```

### Express + Next
Эта связка уже подключена и нужно работать через нее.\
У нас много функционала построено на мидлварях экспресса (подключится позже).

### Разделение кода
Приложение должно быть разделено по страницам.\
Крупные куски кода на страницах выносить и изолировать на уровне фичей.\
Фича — блок содержащий свою ветку стора, селектор, экшены, ui-компоненты (на основе базовых), бизнес логика.\
Иерария примерно такая — `screens > features > components`

