# e2e тесты для бэкендов yandex pay
Всё что полезно протестировать end-to-end на тестовом стенде, можно размещать тут.

## Структура проекта
* tests - интеграционные тесты на pytest. Запускаются с помощью ya make. Указаны как LARGE тесты. Правда, запускать эти large тесты во время PR нет никакого смысла.
* interactions - клиенты для бэкендов пэя и зависимостей. А так же базовый клиент, который умеет в том числе репортить в allure.
* catalog - каталог сущностей для тестов. Базки, пользователи, мерчанты, etc.
* steps - распространенные тестовые шаги. Если какие-то шаги часто встречаются в тестах - можно вынести сюда.
* utils.log - логирование настроено так, что оно пишет и в stdout, и в allure

## Зависимости
### TUS
Удобное управление тестовыми пользователями. Модель такая: есть потребитель (`tus_consumer`) и у него есть набор учёток в том или ином окружении паспорта. Потребитель может создавать себе новые учётки
Чтобы действовать от имени потребителя, нужен [idm](https://idm.yandex-team.ru/system/test-user-service/roles?page=1#f-status=all,f-role=test-user-service/yandex-pay-backend-qa,sort-by=-updated,f-is-expanded=true) доступ для yandex-team пользователя, и его [OAuth-токен](https://wiki.yandex-team.ru/test-user-service/#autentifikacija)
Правильный подход к использованию: идентифицировать юзера не по UID, а по тегу. И если юзера с таким тегом не существует, то пересоздать.
Но мы пока недостаточно зрелые, можно и по уиду. Заранее создаёшь uid, прописываешь в каталоге, и оно работает

## Где запускается
В sandbox.yandex-team.ru.
Пример запуска: https://sandbox.yandex-team.ru/task/1273839938/view. Заходите посмотреть. В т.ч. посмотрите на allure report.
Для того, чтобы всё работало:
* Нужны дырки из sandbox сетей, т.е. из `_CMSEARCHNETS_` ([doc](https://docs.yandex-team.ru/sandbox/dev/environment#intranet))
* Нужны секреты:
    * vault:YANDEX-PAY:yandex-pay-backend-qa-settings
* Настроечки `YA_MAKE_2`. Скорее всего не исчерпывающий, но вот что точно надо
    * `env_vars` - подложить настроечки бинаря в файл, точно так же как у sendr-qtools бэкендов;
    * `test_size_filter` - `large`;
    * `allure_report` - `True`;
    * `allure_report_ttl` - не мусорим;
    * `ya_yt_store`, `ya_yt_token_yav_secret` - экономим топливо и жизнь с помощью кэша;
    * `sandbox_tags` - пока тестировал задачу, она один раз прилетела на виндовую машину. Не завелось. Поэтому добавить `LINUX`. WTF?
    * `targets` - как и всегда, аркадийный путь до проекта.

## Локальная разработка
Локально дырки тоже нужны, но на момент написания доки все необходимые дырки были.
Запускаются как обычные LARGE тесты, см. `Makefile`
При запуске через `make`, подложить кастомный sendr-qtools конфиг можно через override.conf

### Посмотреть allure report
Посмотреть получившийся allure report тоже можно локально.
Для этого поднимается http сервер и с него можно посмотреть отчёт.
Дело в том, что html файл, открытый по file url, не может грузить другие файлы.
Это опция безопасности. Можно отключить её в настройках браузера (или нельзя)
Но проще поднять http сервак с помощью `python3 -m http.server`
