module.exports = {
    extends: ['stylelint-config-prettier'],
    plugins: ['stylelint-scss', 'stylelint-order'],
    rules: {
        'max-nesting-depth': 4,
        'scss/at-extend-no-missing-placeholder': true,
        'scss/dollar-variable-colon-space-after': 'always',
        'scss/dollar-variable-colon-space-before': 'never',
        'scss/dollar-variable-no-missing-interpolation': true,
        'scss/dollar-variable-pattern': '^_?[a-z]+[\\w-]*$',
        'scss/operator-no-newline-before': true,
        'scss/operator-no-newline-after': true,
        'scss/selector-no-redundant-nesting-selector': true,

        'color-hex-case': 'lower',
        'color-hex-length': 'short',
        'color-named': 'never',
        'color-no-hex': null,
        'color-no-invalid-hex': true,

        'font-family-name-quotes': 'always-where-recommended',
        'font-family-no-duplicate-names': true,
        'font-weight-notation': 'named-where-possible',

        'function-disallowed-list': [],
        'function-calc-no-unspaced-operator': true,
        'function-comma-newline-after': 'always-multi-line',
        'function-comma-newline-before': 'never-multi-line',
        'function-comma-space-after': 'always-single-line',
        'function-comma-space-before': 'never',
        'function-linear-gradient-no-nonstandard-direction': true,
        'function-max-empty-lines': 0,
        'function-name-case': 'lower',
        'function-parentheses-newline-inside': 'always-multi-line',
        'function-parentheses-space-inside': 'never-single-line',
        'function-url-quotes': 'always',
        'function-url-scheme-allowed-list': ['https'],
        // правила whitelist и blacklist взаимоисключающие
        // "function-url-scheme-blacklist": ["data"],
        'function-whitelist': null,
        'function-whitespace-after': 'always',

        'number-leading-zero': 'always',
        'number-max-precision': 3,
        'number-no-trailing-zeros': true,

        'string-no-newline': true,
        'string-quotes': 'single',

        'length-zero-no-unit': true,

        'time-min-milliseconds': 100,

        'unit-disallowed-list': [],
        'unit-case': 'lower',
        'unit-no-unknown': true,

        'value-keyword-case': ['lower', { ignoreProperties: '/font/' }],
        'value-no-vendor-prefix': null,

        'value-list-comma-newline-after': 'always-multi-line',
        'value-list-comma-newline-before': 'never-multi-line',
        'value-list-comma-space-after': 'always-single-line',
        'value-list-comma-space-before': 'never',
        'value-list-max-empty-lines': 0,

        'shorthand-property-no-redundant-values': true,

        'property-disallowed-list': [],
        'property-case': 'lower',
        'property-no-unknown': true,
        'property-no-vendor-prefix': null,

        'keyframe-declaration-no-important': true,

        'declaration-bang-space-after': 'never',
        'declaration-bang-space-before': 'always',
        // perttier делает по другому
        // 'declaration-colon-newline-after': 'always-multi-line',
        'declaration-colon-space-after': 'always-single-line',
        'declaration-colon-space-before': 'never',
        // "declaration-no-important": true,
        'declaration-property-unit-disallowed-list': {},
        'declaration-property-value-disallowed-list': {},
        'declaration-block-no-duplicate-properties': [true, { ignore: ['consecutive-duplicates'] }],
        'declaration-block-no-redundant-longhand-properties': [true, { ignoreShorthands: ['/flex-/'] }],
        'declaration-block-no-shorthand-property-overrides': true,
        'declaration-block-semicolon-newline-after': 'always',
        'declaration-block-semicolon-newline-before': 'never-multi-line',
        'declaration-block-semicolon-space-after': 'always-single-line',
        'declaration-block-semicolon-space-before': 'never',
        'declaration-block-single-line-max-declarations': 1,
        'declaration-block-trailing-semicolon': 'always',

        'block-closing-brace-empty-line-before': 'never',
        'block-closing-brace-newline-after': 'always',
        'block-no-empty': true,
        'block-opening-brace-newline-after': 'always',
        'block-closing-brace-newline-before': 'always',
        'block-opening-brace-space-before': 'always',

        'selector-attribute-brackets-space-inside': 'never',
        'selector-combinator-space-after': 'always',
        'selector-combinator-space-before': 'always',
        'selector-max-universal': 0,
        'selector-max-id': 0,
        'selector-pseudo-class-case': 'lower',
        'selector-pseudo-class-no-unknown': [
            true,
            {
                ignorePseudoClasses: ['global'],
            },
        ],
        'selector-pseudo-class-parentheses-space-inside': 'never',
        'selector-pseudo-element-case': 'lower',
        'selector-pseudo-element-colon-notation': 'double',
        'selector-pseudo-element-no-unknown': true,
        'selector-type-case': 'lower',
        'selector-type-no-unknown': [true, { ignoreTypes: ['/^[$]/'] }],
        'selector-max-empty-lines': 0,

        'selector-list-comma-newline-after': 'always',
        'selector-list-comma-newline-before': 'never-multi-line',
        // бесполезно, если `selector-list-comma-newline-after: "always"`
        // "selector-list-comma-space-after": "always-single-line",
        'selector-list-comma-space-before': 'never',

        'rule-empty-line-before': [
            'always',
            {
                except: ['first-nested'],
                ignore: ['after-comment', 'first-nested'],
            },
        ],

        'media-feature-colon-space-after': 'always',
        'media-feature-colon-space-before': 'never',
        'media-feature-name-case': 'lower',
        'media-feature-parentheses-space-inside': 'never',
        'media-feature-range-operator-space-after': 'always',
        'media-feature-range-operator-space-before': 'always',

        'media-query-list-comma-newline-after': 'always-multi-line',
        'media-query-list-comma-space-after': 'always-single-line',

        'at-rule-empty-line-before': [
            'always',
            {
                except: ['first-nested', 'blockless-after-same-name-blockless'],
                ignore: ['after-comment'],
            },
        ],
        'at-rule-name-case': 'lower',
        'at-rule-name-space-after': 'always',
        'at-rule-no-unknown': [
            true,
            {
                ignoreAtRules: ['for', 'mixin', 'define-mixin', 'media', 'mixin-content', 'each', 'include', 'use'],
            },
        ],
        'at-rule-semicolon-newline-after': 'always',

        'comment-no-empty': true,
        'comment-whitespace-inside': 'always',

        indentation: 4,
        linebreaks: 'unix',
        'max-line-length': 120,
        'max-empty-lines': 1,
        'no-descending-specificity': true,
        'no-duplicate-selectors': true,
        'no-empty-source': true,
        'no-eol-whitespace': true,
        'no-extra-semicolons': true,
        'no-invalid-double-slash-comments': true,
        'no-missing-end-of-source-newline': true,
        'no-empty-first-line': true,
        'no-unknown-animations': true,

        'order/order': [
            'dollar-variables',
            'custom-properties',
            'declarations',
            { type: 'at-rule' },
            { type: 'at-rule', hasBlock: true },
            'rules',
        ],
        'order/properties-order': [
            {
                emptyLineBefore: 'always',
                noEmptyLineBetween: true,
                properties: ['position', 'z-index', 'top', 'right', 'bottom', 'left'],
            },
            {
                emptyLineBefore: 'always',
                noEmptyLineBetween: true,
                properties: [
                    'display',
                    'box-orient',
                    'line-clamp',
                    'visibility',
                    'float',
                    'clear',
                    'overflow',
                    'overflow-x',
                    'overflow-y',
                    'overflow-scrolling',
                    'clip',
                    'zoom',
                    'flex',
                    'flex-grow',
                    'flex-direction',
                    'flex-order',
                    'flex-pack',
                    'flex-align',
                    'flex-flow',
                    'flex-basis',
                    'flex-shrink',
                    'flex-wrap',
                    'justify-content',
                    'align-content',
                    'align-items',
                    'align-self',
                    'order',
                    'grid',
                    'grid-area',
                    'grid-template',
                    'grid-template-areas',
                    'grid-template-columns',
                    'grid-template-rows',
                    'grid-auto-columns',
                    'grid-auto-flow',
                    'grid-auto-rows',
                    'grid-column',
                    'grid-column-end',
                    'grid-column-start',
                    'grid-row',
                    'grid-row-end',
                    'grid-row-start',
                ],
            },
            {
                emptyLineBefore: 'always',
                noEmptyLineBetween: true,
                properties: [
                    'box-sizing',
                    'width',
                    'min-width',
                    'max-width',
                    'height',
                    'min-height',
                    'max-height',
                    'margin',
                    'margin-top',
                    'margin-right',
                    'margin-bottom',
                    'margin-left',
                    'padding',
                    'padding-top',
                    'padding-right',
                    'padding-bottom',
                    'padding-left',
                ],
            },
            {
                emptyLineBefore: 'always',
                noEmptyLineBetween: true,
                properties: [
                    'table-layout',
                    'empty-cells',
                    'caption-side',
                    'border-spacing',
                    'border-collapse',
                    'list-style',
                    'list-style-position',
                    'list-style-type',
                    'list-style-image',
                ],
            },
            {
                emptyLineBefore: 'always',
                noEmptyLineBetween: true,
                properties: [
                    'font',
                    'font-family',
                    'src',
                    'font-size',
                    'font-weight',
                    'font-style',
                    'font-variant',
                    'font-size-adjust',
                    'font-stretch',
                    'font-effect',
                    'font-emphasize',
                    'font-emphasize-position',
                    'font-emphasize-style',
                    'font-smooth',
                    'line-height',
                    'content',
                    'quotes',
                    'counter-reset',
                    'counter-increment',
                    'resize',
                    'cursor',
                    'user-select',
                    'nav-index',
                    'nav-up',
                    'nav-right',
                    'nav-down',
                    'nav-left',
                    'text-align',
                    'text-align-last',
                    'vertical-align',
                    'white-space',
                    'text-decoration',
                    'text-emphasis',
                    'text-emphasis-color',
                    'text-emphasis-style',
                    'text-emphasis-position',
                    'text-indent',
                    'text-justify',
                    'letter-spacing',
                    'word-spacing',
                    'text-outline',
                    'text-transform',
                    'text-wrap',
                    'text-orientation',
                    'text-overflow',
                    'text-overflow-ellipsis',
                    'text-overflow-mode',
                    'word-wrap',
                    'word-break',
                    'tab-size',
                    'hyphens',
                    'pointer-events',
                    'caret-color',
                    'direction',
                ],
            },
            {
                emptyLineBefore: 'always',
                noEmptyLineBetween: true,
                properties: [
                    'opacity',
                    'color',
                    'border',
                    'border-width',
                    'border-style',
                    'border-color',
                    'border-top',
                    'border-top-width',
                    'border-top-style',
                    'border-top-color',
                    'border-right',
                    'border-right-width',
                    'border-right-style',
                    'border-right-color',
                    'border-bottom',
                    'border-bottom-width',
                    'border-bottom-style',
                    'border-bottom-color',
                    'border-left',
                    'border-left-width',
                    'border-left-style',
                    'border-left-color',
                    'border-radius',
                    'border-top-left-radius',
                    'border-top-right-radius',
                    'border-bottom-right-radius',
                    'border-bottom-left-radius',
                    'border-image',
                    'border-image-source',
                    'border-image-slice',
                    'border-image-width',
                    'border-image-outset',
                    'border-image-repeat',
                    'outline',
                    'outline-width',
                    'outline-style',
                    'outline-color',
                    'outline-offset',
                    'background',
                    'background-color',
                    'background-image',
                    'background-repeat',
                    'background-attachment',
                    'background-position',
                    'background-position-x',
                    'background-position-y',
                    'background-clip',
                    'background-origin',
                    'background-size',
                    'object-fit',
                    'object-position',
                    'box-decoration-break',
                    'box-shadow',
                    'text-shadow',
                    'mask',
                    'filter',
                    'highlight-color',
                    'fill',
                ],
            },
            {
                emptyLineBefore: 'always',
                noEmptyLineBetween: true,
                properties: [
                    'transition',
                    'transition-delay',
                    'transition-timing-function',
                    'transition-duration',
                    'transition-property',
                    'transform',
                    'transform-origin',
                    'animation',
                    'animation-name',
                    'animation-duration',
                    'animation-play-state',
                    'animation-timing-function',
                    'animation-delay',
                    'animation-iteration-count',
                    'animation-direction',
                ],
            },
        ],
    },
};
