export const CURRENCY_SIGNS: Record<string, string> = {
    RUB: '\u20bd',
    USD: '$',
    EUR: '\u20ac',
    GBP: '\u00a3',
    BYN: 'Br',
    KZT: '\u20b8',
    UAH: '\u20b4',
    AMD: '\u058f',
    GEL: '\u20be',
    AZN: '\u20bc',
    KGS: 'Сом', // Юникодвский символ с буквой "С" с подчеркиванием не поддерживается, сошлись на таком написании
    SEK: 'kr',
    PLN: 'zł',
    INR: '\u20b9',
    CZK: 'Kč',
    CAD: 'C$',
    BRL: 'R$',
    AUD: 'A$',
    UZS: 'So’m',
    CHF: '\u20A3',
    TRY: '\u20BA',
    CNY: '\u00A5',
    ZAR: 'R',
    BGN: 'Лв.',
    RON: 'Lei',
    HKD: 'HK$',
    AED: 'Dh',
};

export const CURRENCY_DIVIDERS: Record<string, string> = {
    RUB: ',',
    USD: '.',
    EUR: '.',
    GBP: '.',
    BYN: ',',
    KZT: ',',
    UAH: ',',
    AMD: ',',
    GEL: ',',
    AZN: ',',
    KGS: ',',
    SEK: ',',
    PLN: ',',
    INR: '.',
    CZK: ',',
    CAD: '.',
    BRL: ',',
    AUD: '.',
    UZS: ',',
};
