import React from 'react';

import { cn } from '@bem-react/classname';

import { Link } from '../link';

import './styles.scss';

const cnPolicy = cn('Policy');

export function Policy(): JSX.Element {
    return (
        <div className={cnPolicy()}>
            <h1>Оферта на оказание услуг «Yandex Pay Checkout»</h1>
            <p>Российская Федерация, Москва</p>
            <p>
                Настоящий документ представляет собой предложение (оферту) Общества с ограниченной
                ответственностью «ЯНДЕКС» (далее — «Яндекс») заключить Договор на оказание Услуг
                «Yandex Pay» на изложенных ниже условиях.
            </p>
            <h2>1. Определения и Термины</h2>
            <p>
                1.1. В целях настоящего документа нижеприведенные термины используются в следующем
                значении:
            </p>
            <p>
                <dfn>Данные статистики</dfn> — данные об оказании Услуг, которые в том числе могут
                содержать сведения о количестве совершенных Пользователями Транзакций за
                определенный период, стоимости Услуг, иные сведения, относящиеся к оказанию Услуг.
            </p>
            <p>
                <dfn>Заказчик</dfn> — лицо, использующее любой из Модулей для автоматизации
                взаимодействия Информационной системы с Сервисом Yandex Pay.
            </p>
            <p>
                <dfn>Информационная система</dfn> — любая система, используемая Пользователем,
                включая систему управления контентом (CMS), для взаимодействия с которой
                предназначен Модуль.
            </p>
            <p>
                <dfn>Клиентский веб-интерфейс</dfn> — программный интерфейс взаимодействия Заказчика
                и Яндекса, позволяющий Заказчику создавать, деактивировать Платежную страницу,
                осуществлять иные действия и иным образом взаимодействовать с Яндексом для целей
                оказания Услуг. Доступ в Клиентский веб-интерфейс осуществляется с использованием
                учетной записи (логина) в Яндекс ID (
                <Link href="https://passport.yandex.ru">https://passport.yandex.ru</Link>
                ), указанной Заказчиком.
            </p>
            <p>
                <dfn>Модули</dfn> — нижеприведенные программные модули, представляющие собой
                программы для ЭВМ:
            </p>
            <ol>
                <li>
                    <p>
                        1) Модуль «Yandex Pay» — позволяет настроить Сервис Yandex Pay и разместить
                        на сайте Пользователя Платежную страницу и кнопку оплаты согласно Условиям.
                    </p>
                </li>
                <li>
                    <p>
                        2) Модуль «Yandex Pay Checkout» - позволяет настроить взаимодействие с
                        функциональностью Сервиса, которая позволяет осуществить выбор условий
                        доставки товара и/или иного предмета платежа и/или передать контактные
                        данные Пользователя согласно п. 2.8 Условий использования Сервиса,
                        опубликованных в сети «Интернет» по адресу:{' '}
                        <Link href="https://yandex.ru/legal/token_pay_termsofuse">
                            https://yandex.ru/legal/token_pay_termsofuse
                        </Link>
                    </p>
                </li>
                <li>
                    <p>
                        3) Модуль «Yandex Pay Checkout» - позволяет настроить взаимодействие с
                        функциональностью Сервиса, которая позволяет осуществить выбор условий
                        доставки товара и/или иного предмета платежа и/или передать контактные
                        данные Пользователя согласно п. 2.8 Условий использования Сервиса,
                        опубликованных в сети «Интернет» по адресу: при технической возможности -
                        иные модули, описание которых доступно по ссылке{' '}
                        <Link href="https://yandex.ru/dev/yandex-pay/doc/tutorial/yandex-pay-checkout/index.html">
                            https://yandex.ru/dev/yandex-pay/doc/tutorial/yandex-pay-checkout/index.html
                        </Link>
                    </p>
                </li>
            </ol>
            <p>
                Любой из программных модулей именуется «Модуль». Модуль «Yandex Pay» и модуль
                «Yandex Pay Checkout» в Информационной системе имеют название «Yandex Pay».
            </p>
            <p>
                <dfn>Отчетный период</dfn> — период времени, исчисляемый с первого числа
                календарного месяца по последнее число соответствующего календарного месяца
                включительно. Первый Отчетный период начинается в день заключения Договора, или на
                следующий день после окончания Триального периода, и оканчивается в последний день
                месяца заключения Договора включительно. Последний Отчетный месяц начинается в
                первый день месяца прекращения Договора и оканчивается в день прекращения Договора
                включительно.
            </p>
            <p>
                <dfn>Платежная страница</dfn> — веб-страница, на которую переходит Пользователь в
                целях совершения оплаты в адрес Заказчика.
            </p>
            <p>
                <dfn>Пользователь</dfn> — лицо, использующее Сервис в целях совершения безналичной
                оплаты в адрес Заказчика.
            </p>
            <p>
                <dfn>Транзакция</dfn> — оплата, совершенная Пользователем с использованием Модуля
                «Yandex Pay Checkout» на сайте Заказчика.
            </p>
            <p>
                <dfn>Товар</dfn> — товар, работа и/или услуга (в том числе несколько товаров, работ
                и/или услуг) реализуемые Заказчиком, в отношении которых между Заказчиком и
                Пользователем заключен договор об их реализации, оплату которых осуществляет
                Пользователь с помощью Сервиса. Под Товаром понимаются только такие товары, работы
                и/или услуги, оборот которых не ограничен при их реализации Заказчиком Пользователю
                в соответствии с действующим законодательством РФ.
            </p>
            <p>
                <dfn>Триальный период</dfn> — период, равный 30 (тридцати) дням, в течение которого
                услуги оказываются безвозмездно в целях ознакомления с Сервисом «Yandex Pay
                Checkout». Триальный период начинается с момента проведения первой Транзакции.
            </p>
            <p>
                <dfn>Условия использования Сервиса</dfn> — Условия использования сервиса Yandex pay,
                опубликованные в сети «Интернет» по адресу:{' '}
                <Link href="https://yandex.ru/legal/token_pay_termsofuse">
                    https://yandex.ru/legal/token_pay_termsofuse
                </Link>
            </p>
            <p>
                <dfn>Услуги (Услуги «Yandex Pay Check out»)</dfn> — услуги Яндекса, связанные с
                предоставлением Заказчику функционал Сервиса «Yandex Pay Checkout» на условиях п.
                2.2. Оферты.
            </p>
            <p>
                Иные термины, используемые в Оферте, приведены в соответствии со значениями, данными
                в Условиях.
            </p>
            <h2>2. Предмет Договора</h2>
            <ol>
                <li>
                    <p>
                        2.1 Предметом Договора является возмездное оказание Яндексом Заказчику Услуг
                        на условиях Оферты.
                    </p>
                </li>
                <li>
                    <p>
                        2.2 В рамках оказания Услуг Яндекс предоставляет Заказчику функционал
                        Сервиса «Yandex Pay Checkout», в рамках которого посредством Интерфейса
                        Сервиса:
                    </p>
                    <ol>
                        <li>
                            <p>
                                2.2.1. для Пользователя отображаются возможные условия доставки
                                товара и/или иного предмета платежа, данные о которых переданы
                                Яндексу посредством API,
                            </p>
                        </li>
                        <li>
                            <p>
                                2.2.2. Пользователю предоставляется возможность выбора условий
                                доставки,
                            </p>
                        </li>
                        <li>
                            <p>
                                2.2.3. выбранные Пользователем условия доставки передаются Яндексом
                                Заказчику посредством API.
                            </p>
                        </li>
                    </ol>
                </li>
                <li>
                    <p>
                        2.3. В рамках Сервиса Яндекс вправе предоставить иной функционал в
                        дополнение к указанному в п. 2.2. Оферты, а также прекращать его
                        предоставление в одностороннем порядке.
                    </p>
                </li>
                <li>
                    <p>
                        2.4. Услуги оказываются Яндексом на территории, на которой с помощью Сервиса
                        доступно размещение Заказа для Пользователя. При этом Яндекс в одностороннем
                        порядке определяет и изменяет указанную территорию.
                    </p>
                </li>
                <li>
                    <p>
                        2.5. Обязательным условием оказания Яндексом Услуг является принятие и
                        соблюдение Заказчиком требований и положений, изложенных в Оферте, а также в
                        следующих документах:
                    </p>
                    <ul>
                        <li>
                            <p>
                                Пользовательское соглашение сервисов Яндекса, размещенное в сети
                                Интернет по адресу:{' '}
                                <Link href="https://yandex.ru/legal/rules">
                                    https://yandex.ru/legal/rules
                                </Link>
                                ;
                            </p>
                        </li>
                        <li>
                            <p>
                                «Политика конфиденциальности», размещенная в сети Интернет по
                                адресу:{' '}
                                <Link href="https://yandex.ru/legal/confidential">
                                    https://yandex.ru/legal/confidential
                                </Link>
                                ;
                            </p>
                        </li>
                        <li>
                            <p>
                                «Политика конфиденциальности», размещенная в сети Интернет по
                                адресу:{' '}
                                <Link href="https://yandex.ru/legal/confidential">
                                    https://yandex.ru/legal/confidential
                                </Link>
                                ;
                            </p>
                        </li>
                    </ul>
                </li>
                <li>
                    <p>
                        2.6. Яндекс приступает к оказанию Услуг по Договору после предоставления
                        Заказчиком в Клиентском веб-интерфейсе Информации в полном объеме,
                        предусмотренном Офертой, законодательством, а также требуемой Яндексом.
                    </p>
                </li>
            </ol>
            <h2>3. Условия оказания услуг</h2>
            <ol>
                <li>
                    <p>
                        3.1. Обязательным условием оказания Яндексом Услуг является принятие и
                        соблюдение Заказчиком требований и положений, изложенных в Договоре,
                        Условиях использования Сервиса, Правилах оформления бренда Yandex Pay (
                        <Link href="https://yandex.ru/dev/yandex-pay/doc/design/index.html">
                            https://yandex.ru/dev/yandex-pay/doc/design/index.html
                        </Link>
                        ), а также в документе «Пользовательское соглашение сервисов Яндекса»,
                        размещенном в сети Интернет по адресу:{' '}
                        <Link href="https://yandex.ru/legal/rules">
                            https://yandex.ru/legal/rules
                        </Link>
                        .
                    </p>
                    <p>
                        3.2. Заказчик обязан обеспечить передачу Яндексу посредством API
                        определенных Заказчиком условий доставки, подлежащих отображению
                        Пользователю, осуществлять иное взаимодействие в порядке, предусмотренном
                        Документацией SDK, Правилами интеграционного взаимодействия, Правилах
                        оформления бренда Yandex Pay либо в порядке, согласованном по электронной
                        почте или иным способом между Яндексом и Заказчиком.
                    </p>
                    <p>
                        3.3. Настоящим Заказчик соглашается, что данные по обороту денежных средств,
                        оплаченных за Товары с помощью Сервиса, могут быть предоставлены Яндексом
                        своим партнерам в целях расчета вознаграждения партнеров.
                    </p>
                </li>
            </ol>
            <h2>4. Права и обязанности сторон</h2>
            <ol>
                <li>
                    <p>4.1. Яндекс обязуется: </p>
                    <ol>
                        <li>
                            <p>
                                По запросу Заказчика, отправленного на адрес электронной почты{' '}
                                <Link href="mailto:ypay_checkout@yandex-team.ru">
                                    ypay_checkout@yandex-team.ru
                                </Link>
                                и или, при наличии технической возможности -в Клиентский
                                веб-интерфейс, в течение 10 (десяти) дней с даты получения запроса
                                направить Данные статистики за период, указанный Заказчиком в таком
                                запросе по электронной почте.
                            </p>
                        </li>
                    </ol>
                </li>
                <li>
                    <p>4.2. Яндекс имеет право: </p>
                    <ol>
                        <li>
                            <p>
                                4.2.1. Временно приостановить оказание Заказчику Услуг по
                                техническим, технологическим или иным причинам, препятствующим
                                оказанию Услуг, на время устранения таких причин.
                            </p>
                        </li>
                        <li>
                            <p>
                                4.2.2. Приостановить оказание Услуг и и/или отказаться от исполнения
                                Договора в одностороннем внесудебном порядке путем уведомления
                                Заказчика в любом из случаев:
                            </p>
                            <ol>
                                <li>
                                    <p>
                                        4.2.2.1. неоднократное нарушение Заказчиком условий
                                        заключаемых с Пользователями договоров о реализации Товара,
                                        оплата которого осуществляется Пользователем в рамках
                                        Транзакции;
                                    </p>
                                </li>
                                <li>
                                    <p>
                                        4.2.2.2. нарушение Заказчиком при создании, деактивации
                                        Транзакции требований, предусмотренным Договором,
                                        Регулирующими документами;
                                    </p>
                                </li>
                                <li>
                                    <p>
                                        4.2.2.3. Заказчик имеет задолженность по оплате услуг
                                        Яндекса (в том числе нарушил срок оплаты Услуг, оказанных
                                        Заказчику по Договору) как по настоящему Договору, так и по
                                        другим договорам, заключенным между Яндексом и Заказчиком;
                                    </p>
                                </li>
                                <li>
                                    <p>
                                        4.2.2.4. при нарушении Заказчиком обязательств, принятых в
                                        соответствии с Договором.
                                    </p>
                                </li>
                            </ol>
                        </li>
                        <li>
                            <p>
                                4.2.3. Осуществлять любые действия (контрольные мероприятия) по
                                проверке соответствия Транзакции требованиям Оферты. Данные,
                                полученные в результате осуществления контрольных мероприятий,
                                являются достаточным, но не единственным основанием для установления
                                несоответствия Платежа требованиям Договора. При этом Яндекс
                                самостоятельно определяет способы, периодичность и основания
                                проведения контрольных мероприятий.
                            </p>
                        </li>
                        <li>
                            <p>
                                4.2.4. Изменять размер стоимости оплаты услуг, используемый для
                                расчета указанной стоимости в соответствии с п. 5.1 Оферты.
                            </p>
                        </li>
                        <li>
                            <p>4.2.5. Яндекс имеет иные права, предусмотренные Оферта. </p>
                        </li>
                    </ol>
                </li>
                <li>
                    <p>4.3. Заказчик обязуется: </p>
                    <ol>
                        <li>
                            <p>
                                4.3.1. Использовать Сервис в соответствии с требованиями Оферты (в
                                т.ч. документов, указанных в п. 3.1 Оферты).
                            </p>
                        </li>
                        <li>
                            <p>
                                4.3.2. Обеспечить до совершения Пользователем Транзакции доведение
                                до Пользователя всей необходимой информации о Заказчике и Товаре.
                            </p>
                        </li>
                        <li>
                            <p>
                                4.3.3. В случае изменения данных о Заказчике, предоставленных
                                Заказчиком, не позднее, чем за 3 (три) календарных дня до даты
                                изменения указанных данных, предоставить Яндексу измененные данные
                                по электронной почте или (при наличии такого функционала) с помощью
                                Клиентского веб-интерфейса. В связи с техническими особенностями
                                работы Сервиса и Клиентского веб-интерфейса в случае изменения ИНН
                                Заказчика (в том числе в связи с правопреемством) для продолжения
                                оказания Услуг ему необходимо заключить отдельный договор с Яндексом
                                с предметом и условиями, аналогичными предусмотренным в настоящем
                                Договоре, а также расторгнуть настоящий Договор.
                            </p>
                        </li>
                        <li>
                            <p>
                                4.3.4. По требованию Яндекса в срок, не превышающий 2 (двух)
                                календарных дней с момента получения данного требования,
                                предоставить надлежаще заверенные копии документов, подтверждающие
                                информацию о Товарах и/или Заказчике, предоставленную Яндексу, в том
                                числе в составе Платежей. Стороны признают, что указанная информация
                                не является конфиденциальной.
                            </p>
                        </li>
                        <li>
                            <p>4.3.5. Оплатить Услуги в установленные в Оферты сроки и порядке.</p>
                        </li>
                        <li>
                            <p>4.3.6. Выполнять иные обязанности, предусмотренные Оферты. </p>
                        </li>
                    </ol>
                </li>
                <li>
                    <p>4.4. Заказчик имеет право: </p>
                    <ol>
                        <li>
                            <p>
                                4.4.1. На получение Данных статистики в установленном Офертой
                                порядке.
                            </p>
                        </li>
                        <li>
                            <p>
                                4.4.2. В случае несогласия с изменениями, внесенными Яндексом в
                                Оферту и/или документы, указанные в п. 2.5 Оферта, отказаться от
                                исполнения Оферты в одностороннем порядке, письменно уведомив Яндекс
                                в срок не позднее 7 (семи) календарных дней с момента вступления
                                указанных изменений в силу и оплатив Яндексу стоимость фактически
                                оказанных Услуг, а также исполнив иные денежные обязательства перед
                                Яндексом, возникшие на дату прекращения действия Договора. Договор
                                считается расторгнутым с момента получения Яндексом уведомления
                                Заказчика.
                            </p>
                        </li>
                    </ol>
                </li>
            </ol>
            <h2>5. Стоимость услуг, порядок приемки услуг и расчетов</h2>
            <ol>
                <li>
                    <p>
                        5.1. Стоимость Услуг, оказанных Яндексом по Оферте в отчетном периоде
                        оказания Услуг (далее – «Отчетный период»), определяется в соответствии с
                        Данными статистики Яндекса в зависимости от общей суммы всех совершенных
                        Пользователями Транзакций (с учетом НДС, если применимо) в отношении
                        Заказчика в течение Отчетного периода в размере, указанном в таблице ниже:
                    </p>
                    <table>
                        <tbody>
                            <tr>
                                <th>
                                    Общая сумма всех совершенных Пользователями Транзакций (включая
                                    НДС, если применимо) в отношении Заказчика в течение Отчетного
                                    периода (в рублях)
                                </th>
                                <th>
                                    Применимый размер стоимости Услуг, оказанных Яндексом в
                                    соответствующем Отчетном периоде (включая НДС, если применимо)
                                </th>
                            </tr>
                            <tr>
                                <td>До 5 000 000 рублей</td>
                                <td>
                                    1,5 процента от суммы всех совершенных Пользователями Транзакций
                                    (включая НДС, если применимо) в соответствующем Отчетном периоде
                                </td>
                            </tr>
                            <tr>
                                <td>От 5 000 000 рублей до 50 000 000 рублей</td>
                                <td>
                                    1 процент от суммы всех совершенных Пользователями Транзакций
                                    (включая НДС, если применимо) в соответствующем Отчетном периоде
                                </td>
                            </tr>
                            <tr>
                                <td>От 50 000 000 рублей</td>
                                <td>
                                    0,5 процента от суммы всех совершенных Пользователями Транзакций
                                    (включая НДС, если применимо) в соответствующем Отчетном периоде
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </li>
                <li>
                    <p>
                        5.2. Оплата Услуг производится Заказчиком в российских рублях в безналичном
                        порядке.
                    </p>
                </li>
                <li>
                    <p>
                        5.3. Стоимость оказанных Услуг указывается в акте об оказанных услугах
                        (далее – Акт), формируемом Яндексом в порядке, предусмотренном п. 5.6
                        Оферты.
                    </p>
                </li>
                <li>
                    <p>
                        5.4. Ежемесячно в течение 3 (трех) дней с даты окончания Отчетного периода
                        Яндекс формирует Отчет, содержащий Данные статистики, и отправляет его
                        Заказчику на адрес электронной почты. Заказчик в течение 3 (трех) дней может
                        прислать мотивированное возражения на Отчет. Если в течение указанного срока
                        мотивированное возражение не будет получено, Отчет считается принятым
                        Заказчиком.
                    </p>
                </li>
                <li>
                    <p>
                        5.5. Отчет и возражение направляются в электронном виде на электронную почту{' '}
                        <Link href="mailto:ypay_checkout@yandex-team.ru">
                            ypay_checkout@yandex-team.ru
                        </Link>
                    </p>
                </li>
                <li>
                    <p>
                        5.6. Ежемесячно в течение 7 (семи) рабочих дней с даты окончания Отчетного
                        периода Яндекс формирует Счет на оплату, Счет - фактуру и односторонний Акт
                        в соответствии с объемом фактически оказанных в Отчетном периоде Услуг.
                    </p>
                </li>
                <li>
                    <p>
                        5.7. Оплата оказанных услуг производится на основании Акта ежемесячно не
                        позднее 3 (трех) рабочих дней со дня выставления Акта.
                    </p>
                </li>
                <li>
                    <p>
                        5.8. Заказчик считается исполнившим свои обязательства по оплате Услуг с
                        момента поступления денежных средств на расчетный счет Яндекса.
                    </p>
                </li>
                <li>
                    <p>
                        5.9. Первый месяц Яндекс предоставляет Заказчику Триальный период для
                        ознакомления с Сервисом.
                    </p>
                </li>
                <li>
                    <p>
                        5.10. Стороны согласовали, что Акт направляется Яндексом Заказчику на адрес
                        электронной почты, указанный при акцепте Оферты в Клиентском веб-интерфейсе.
                        Стороны признают, что копии Акта, направленные Яндексом Заказчику по
                        электронной почте, будут применяться Заказчиком в процессе приемки Услуг.
                        Датой получения копии текста Акта, направленных Яндексом Заказчику по
                        электронной почте, считается следующий рабочий день за днем отправки.
                    </p>
                </li>
                <li>
                    <p>
                        5.11. Услуги считаются оказанными Яндексом надлежащим образом и принятыми
                        Заказчиком в указанном в Акте объеме, если в течение 13 (тринадцати) дней с
                        даты Акта Яндекс не получил от Заказчика мотивированных письменных
                        возражений на электронную почту{' '}
                        <Link href="mailto:ypay_checkout@yandex-team.ru">
                            ypay_checkout@yandex-team.ru
                        </Link>
                        . По истечении срока, указанного выше, претензии Заказчика по Акту в том
                        числе по количеству (объему), стоимости и качеству Услуг, не принимаются.
                    </p>
                </li>
                <li>
                    <p>
                        5.12. Акт может быть направлен на бумажном носителе на почтовый адрес
                        Заказчика, указанный в Клиентском веб-интерфейсе.
                    </p>
                </li>
            </ol>
            <h2>6. Акцепт Оферты и заключение Договора</h2>
            <ol>
                <li>
                    <p>
                        6.1. Заказчик производит Акцепт Оферты путем последовательного совершения
                        следующих действий (в совокупности):
                    </p>
                    <ol>
                        <li>
                            <p>6.1.1. установка Модуля из Информационной системы</p>
                        </li>
                        <li>
                            <p>
                                6.1.2. ввод необходимой информации в Клиентский веб-интерфейс,
                                ознакомление и согласие с условиями Оферты в Сервисе через Модуль
                            </p>
                        </li>
                    </ol>
                </li>
                <li>
                    <p>
                        6.2. Обязательным условием Акцепта Оферты является наличие учетной записи
                        Заказчика в Информационной системе.
                    </p>
                </li>
                <li>
                    <p>
                        6.3. Яндекс вправе отказать Заказчику в заключении Договора на любом этапе
                        переговоров, если Заказчик не удовлетворяет критериям добросовестности и
                        благонадежности, установленным Яндексом. Яндекс вправе не раскрывать
                        Заказчику причины, по которым Яндекс относит Заказчика к контрагентам,
                        которые не удовлетворяют критериям добросовестности и благонадежности.
                    </p>
                </li>
            </ol>
            <h2>7. Срок действия и изменение условий Оферты</h2>
            <ol>
                <li>
                    <p>
                        7.1. Оферта вступает в силу с даты ее размещения в сети Интернет по адресу{' '}
                        <Link href="https://yandex.ru/legal/offer_checkout_merchant">
                            https://yandex.ru/legal/offer_checkout_merchant
                        </Link>{' '}
                        если иной срок не указан при размещении, и действует до момента отзыва
                        Оферты Яндексом.
                    </p>
                </li>
                <li>
                    <p>
                        7.2. Яндекс оставляет за собой право внести изменения в условия Оферты,
                        документы, указанные в п. 2.5 Оферты, отозвать Оферту в любой момент по
                        своему усмотрению.
                    </p>
                    <p>
                        Такие изменения или отзыв Оферты вступают в силу с момента размещения
                        измененного текста Оферты (документов, указанных в п. 2.5 Оферты) в сети
                        Интернет по адресу{' '}
                        <Link href="https://yandex.ru/legal/offer_checkout_merchant">
                            https://yandex.ru/legal/offer_checkout_merchant
                        </Link>{' '}
                        и/или адресам, указанным в п. 2.5 Оферты, для соответствующих документов,
                        если иной срок вступления изменений в силу не определен дополнительно при
                        таком размещении.
                    </p>
                </li>
                <li>
                    <p>
                        7.3. Акцепт Оферты Заказчиком, произведенный согласно разделу 6 Оферты,
                        порождает Договор (статья 438 Гражданского Кодекса РФ) на условиях Оферты.
                    </p>
                </li>
                <li>
                    <p>
                        7.4. Договор вступает в силу с момента Акцепта Оферты Заказчиком и
                        заключается на неопределенный срок.
                    </p>
                </li>
                <li>
                    <p>
                        7.5. Яндекс вправе в одностороннем порядке вносить изменения в Договор.
                        Заказчик соглашается и признает, что внесение изменений в Оферту согласно
                        п.7.2. Оферты влечет за собой внесение этих изменений в заключенный и
                        действующий между Заказчиком и Яндексом Договор, эти изменения в Договор
                        вступают в силу одновременно с такими изменениями в Оферту (в том числе в
                        документы, указанные в п. 2.5. Оферты). В случае отзыва Оферты Яндексом в
                        течение срока действия Договора, Договор считается прекращенным с момента
                        отзыва, если иное не оговорено Яндексом при отзыве Оферты.
                    </p>
                </li>
                <li>
                    <p>7.6. Договор может быть расторгнут</p>
                    <ol>
                        <li>
                            <p>7.6.1. по соглашению Сторон в любое время;</p>
                        </li>
                        <li>
                            <p>
                                7.6.2. Яндексом в одностороннем внесудебном порядке путем
                                направления письменного уведомления Заказчику по электронной почте
                                не позднее, чем за 5 (Пять) рабочих дней до даты прекращения
                                Договора;
                            </p>
                        </li>
                        <li>
                            <p>
                                7.6.3. Заказчиком в одностороннем внесудебном порядке с уведомлением
                                Яндекса по электронной почте за 7 (Семь) рабочих дней до расторжения
                            </p>
                        </li>
                        <li>
                            <p>
                                7.6.4. по иным основаниям, предусмотренным Офертой и/или действующим
                                законодательством РФ.{' '}
                            </p>
                        </li>
                    </ol>
                </li>
                <li>
                    <p>
                        7.7. Обязательства Сторон по Договору, которые в силу своей природы должны
                        продолжать действовать (включая обязательства в отношении
                        конфиденциальности, проведения взаиморасчетов, использованию информации, но,
                        не ограничиваясь указанным), остаются в силе после окончания действия
                        Договора.
                    </p>
                </li>
                <li>
                    <p>
                        7.8. Прекращение срока действия Договора по любому основанию не освобождает
                        Стороны от ответственности за нарушения условий Договора, возникшие в
                        течение срока его действия.
                    </p>
                </li>
            </ol>
            <h2>8. Условия использования Модулей</h2>
            <ol>
                <li>
                    <p>
                        8.1. В случае использования Заказчиком любого из Модулей, предназначенного
                        для взаимодействия с Информационной системой, являющейся CMS, принимая
                        условия Лицензии, Заказчик подтверждает, что является владельцем сайта в
                        сети «Интернет», на котором с помощью Модуля устанавливается Сервис, то есть
                        является лицом, самостоятельно и по своему усмотрению определяющим порядок
                        использования сайта, в том числе порядок размещения информации на таком
                        сайте, а также определяющим состав функций такого сайта, и имеет необходимые
                        права для внесения изменений на таком сайте.
                    </p>
                </li>
                <li>
                    <p>
                        8.2. Модули предоставляются Яндексом Заказчику на условиях «как есть».
                        Заказчик должен самостоятельно оценивать риски и самостоятельно нести всю
                        ответственность за свои действия, связанные с использованием Модулей. Яндекс
                        не гарантирует соответствие Модулей целям и ожиданиям Заказчика,
                        бесперебойную и безошибочную работу Модулей. Яндекс вправе вносить любые
                        изменения в структуру и алгоритмы работы Модулей, приостанавливать его
                        работоспособность или работоспособность его функций, изменять или прекращать
                        выполнение функций Модулей без заблаговременного предупреждения Заказчика и
                        без выражения последним согласия на это.
                    </p>
                </li>
                <li>
                    <p>
                        8.3. Яндекс на условиях простой (неисключительной) лицензии, предоставляет
                        Заказчику непередаваемое право использования Модулей на территории всего
                        мира на срок действия Оферты либо на срок действия исключительных прав на
                        каждый из Модулей (в зависимости от того, какой срок наступит ранее)
                        следующими способами:
                    </p>
                    <ol>
                        <li>
                            <p>
                                8.3.1. Применять Модули по прямому функциональному назначению,
                                описанному в п 8.1 Оферты, в целях чего производить их
                                воспроизведение, в том числе скачивание или установку на устройствах
                                Заказчика. Заказчик вправе использовать Модули на неограниченном
                                количестве устройств
                            </p>
                        </li>
                        <li>
                            <p>
                                8.3.2. Заказчик не вправе распространять любой из Модулей и/или все
                                Модули, изменять наименование любого из Модулей и/или всех Модулей,
                                изменять и/или удалять знаки охраны авторского права или иное
                                указание на Яндекса, если они включены в состав Модулей.
                            </p>
                        </li>
                    </ol>
                </li>
                <li>
                    <p>
                        8.4. Заказчик, получивший доступ к любому из Модулей, обязуется соблюдать
                        следующие ограничения: не изменять, не модифицировать, не декомпилировать
                        и/или не производить иные действия с любым из Модулей и/или со всеми Модуля
                        или исходным кодом таких Модулей, имеющие целью создание производного
                        произведения с использованием таких Модулей.
                    </p>
                </li>
                <li>
                    <p>
                        8.5. Заказчик настоящим уведомлен и согласен с тем, что при использовании
                        любого из Модулей Заказчиком Яндекс осуществляет мониторинг всей
                        деятельности по использованию такого Модуля и может собирать, анализировать
                        статистику действий Заказчика, осуществленных с помощью Модуля. Заказчик
                        настоящим уведомлен и соглашается с передачей любому из Модулей следующих
                        сведений:
                    </p>
                    <ul>
                        <li>
                            <p>
                                Название Информационной системы, используемой Заказчиком, версия
                                Информационной системы;
                            </p>
                        </li>
                        <li>
                            <p>Настройки, изменение настроек, установка Модуля;</p>
                        </li>
                        <li>
                            <p>Домен веб-сайта, на котором установлен Модуль;</p>
                        </li>{' '}
                        <li>
                            <p>Активация и деактивация Модуля;</p>
                        </li>{' '}
                        <li>
                            <p>Обновление Модуля;</p>
                        </li>
                        <li>
                            <p>Удаление Модуля;</p>
                        </li>{' '}
                        <li>
                            <p>Установка ключей Модуля.</p>
                        </li>{' '}
                        <li>
                            <p>
                                Информацию о том, какое событие произошло на веб-сайте, на котором
                                установлен Модуль (отображение платежной кнопки или переход по этой
                                кнопке), а также id такого события
                            </p>
                        </li>
                    </ul>
                </li>
                <li>
                    <p>
                        8.6. Заказчик соглашается с тем, что передача указанных в п. 8.5 Оферты
                        сведений Яндексу является технологически необходимой для обеспечения
                        корректной работы Модулей. Указанные данные могут быть также использованы
                        Яндексом для проведения аналитики и обработки статистических данных в целях
                        усовершенствования работы Сервиса, обеспечения безопасности его работы и
                        устранения ошибок функционирования.
                    </p>
                </li>
                <li>
                    <p>
                        8.7. Заказчик соглашается с тем, что работа Сервиса зависит от Шлюза и
                        взаимодействия Заказчика и Яндекса со Шлюзом. Заказчик обязуется
                        самостоятельно заключить договоры со Шлюзом, необходимые для работы Сервиса.
                    </p>
                </li>
            </ol>
            <h2>9. Гарантии</h2>
            <ol>
                <li>
                    <p>
                        9.1. В течение срока действия Договора Яндекс предпримет все усилия для
                        устранения каких-либо сбоев и ошибок в работе Сервиса в случае их
                        возникновения. При этом Яндекс не гарантирует отсутствия ошибок и сбоев в
                        работе Сервиса, а также при оказании Услуг, в том числе в отношении работы
                        программного обеспечения.
                    </p>
                </li>{' '}
                <li>
                    <p>
                        9.2. За исключением гарантий, прямо указанных в тексте Оферты, Яндекс не
                        предоставляет никаких иных прямых или подразумеваемых гарантий по Договору и
                        прямо отказывается от каких-либо гарантий или условий в отношении не
                        нарушения прав и соответствия Услуг конкретным целям Заказчика.
                    </p>
                </li>{' '}
                <li>
                    <p>
                        9.3. Производя Акцепт Оферты, Заказчик (или представитель Заказчика, в т.ч.
                        физическое лицо, должным образом уполномоченное заключить Договор от лица
                        Заказчика) подтверждает и гарантирует Яндексу, что:
                    </p>
                    <ol>
                        <li>
                            <p>
                                9.3.1. Заказчик (представитель Заказчика) указал достоверные данные
                                при регистрации в Клиентском веб-интерфейсе и достоверные данные
                                Заказчика при оформлении платежных документов при оплате Услуг.
                            </p>
                        </li>
                        <li>
                            <p>
                                9.3.2. Заказчик гарантирует, что будет производить обработку
                                персональных данных в рамках исполнения и заключения Договора в
                                соответствии с требованиями Федерального закона от 27.07.2006 года №
                                152-ФЗ «О персональных данных» и раздела 9 Оферты.
                            </p>
                        </li>
                    </ol>
                </li>
            </ol>
            <h2>10. Ответственность и ограничение ответственности</h2>
            <ol>
                <li>
                    <p>
                        10.1. За нарушение условий Договора Стороны несут ответственность,
                        установленную Договором и/или действующим законодательством РФ.
                    </p>
                </li>
                <li>
                    <p>
                        10.2. Яндекс ни при каких обстоятельствах не несет никакой ответственности
                        по Договору за: а) какие-либо косвенные убытки и/или упущенную выгоду
                        Заказчика и/или третьих сторон вне зависимости от того, мог Яндекс
                        предвидеть возможность таких убытков или нет.
                    </p>
                </li>
                <li>
                    <p>
                        10.3. Совокупный размер ответственности Яндекса по Договору, включая размер
                        штрафных санкций (пеней, неустоек) и/или возмещаемых убытков, по любому иску
                        или претензии в отношении Договора или его исполнения, ограничивается 10 %
                        стоимости Услуг по Договору за Отчетный период, в котором допущено нарушение
                        (либо в котором было завершено длящееся нарушение).
                    </p>
                </li>
                <li>
                    <p>
                        10.4. Стороны освобождаются от ответственности за частичное или полное
                        неисполнение обязательств по настоящему Договору, если это неисполнение
                        явилось следствием обстоятельств непреодолимой силы, которые возникли после
                        заключения Договора, либо если неисполнение обязательств Сторонами по
                        Договору явилось следствием событий чрезвычайного характера, которые Стороны
                        не могли ни предвидеть, ни предотвратить разумными мерами.
                    </p>
                </li>
                <li>
                    <p>10.5. Заказчик несет ответственность в полном объеме за:</p>
                    <ol>
                        <li>
                            <p>
                                а) достоверность сведений, гарантий и заверений, указанных им при
                                регистрации в Сервисе;{' '}
                            </p>
                        </li>
                        <li>
                            <p>
                                б) качество Товаров и исполнение обязательств перед Пользователями;
                            </p>
                        </li>
                        <li>
                            <p>в) указание недостоверных условий доставки;</p>
                        </li>
                        <li>
                            <p>г) за передачу персональных данных Пользователей третьим лицам;</p>
                        </li>
                        <li>
                            <p>
                                д) мошеннические действия Пользователей, ставших известными
                                Заказчику.
                            </p>
                        </li>
                    </ol>
                </li>
                <li>
                    <p>
                        10.6. Принимая во внимание условия п. 10.5 Оферты, Заказчик обязуется своими
                        силами и за свой счет разрешать споры и урегулировать претензии третьих лиц,
                        либо возместить убытки (включая судебные расходы) причиненные Яндексу, в том
                        числе в связи с претензиями третьих лиц относительно Товаров. Заказчик
                        обязуется незамедлительно по требованию Яндекса предоставить ему всю
                        запрашиваемую информацию, содействовать Яндексу в урегулировании претензий
                        третьих лиц.{' '}
                    </p>
                </li>
            </ol>
            <h2>11. Конфиденциальная информация</h2>
            <ol>
                <li>
                    <p>
                        11.1. Заказчик обязуется сохранять в тайне и считать конфиденциальной
                        информацию о коммерческих условиях Договора (в том числе стоимости Услуг),
                        технических особенностях Сервиса и его функционала, а также иную информацию,
                        переданную Яндексом Заказчику, и обозначенную Яндексом как конфиденциальная
                        информация (далее — «Конфиденциальная Информация»), и не раскрывать, не
                        разглашать, не опубликовывать или иным способом не предоставлять такую
                        информацию какой-либо третьей стороне без предварительного письменного
                        разрешения Яндекса.
                    </p>
                </li>
                <li>
                    <p>
                        11.2. Обязательство сохранять в тайне Конфиденциальную Информацию вступает в
                        силу с момента заключения Договора и остается в силе в течение 3 (Трех) лет
                        с момента окончании срока действия Договора или его расторжения по
                        какой-либо причине.
                    </p>
                </li>
                <li>
                    <p>
                        11.3. Стороны пришли к соглашению о том, что Яндекс вправе раскрывать
                        третьим лицам любую информацию (включая сведения о Заказчике, а также
                        Информацию, полученную от Заказчика в рамках выполнения Сторонами своих
                        обязательств по Договору.
                    </p>
                </li>
            </ol>
            <h2>12. Иные условия</h2>
            <ol>
                <li>
                    <p>
                        12.1. Договор, его заключение и исполнение регулируется действующим
                        законодательством Российской Федерации. Все вопросы, не урегулированные
                        Офертой или урегулированные не полностью, регулируются в соответствии с
                        материальным и процессуальным правом Российской Федерации. Если споры между
                        Заказчиком и Яндексом в отношении Договора не разрешены путем переговоров
                        Сторон, они подлежат рассмотрению в порядке, предусмотренном действующим
                        законодательством в Арбитражном суде г. Москвы.
                    </p>
                </li>
                <li>
                    <p>
                        12.2. Заказчик обязуется поддерживать сообщенные Яндексу Реквизиты в
                        актуальном состоянии, а в случае изменения корректировать их в Сервисе.
                    </p>
                </li>
                <li>
                    <p>
                        12.3. В случае если одно или более положений Оферты являются по какой-либо
                        причине недействительными, не имеющими юридической силы, такая
                        недействительность не оказывает влияния на действительность любого другого
                        положения Оферты (Договора), которые остаются в силе.
                    </p>
                </li>
                <li>
                    <p>
                        12.4. Не вступая в противоречие с условиями Оферты, Заказчик и Яндекс вправе
                        в любое время оформить Договор на оказание Услуг в форме письменного
                        двухстороннего документа.
                    </p>
                </li>
                <li>
                    <p>
                        12.5. Яндекс не является уполномоченной организацией по смыслу Закона РФ от
                        07.02.1992 г. № 2300-1 «О защите прав потребителей», и не осуществляет
                        рассмотрение и удовлетворение претензий Пользователей в отношении Работ,
                        Товаров, в том числе их ненадлежащего качества, Заказ которых оформлен
                        Пользователем на Сервисе.
                    </p>
                </li>
                <li>
                    <p>
                        12.6. Заказчик не вправе передавать свои права по Договору какой-либо
                        третьей стороне без предварительного согласия Яндекса. Обязанность
                        подтверждения наличия такого согласия возлагается на Заказчика. При этом
                        Яндекс вправе передавать права и обязанности по Договору без
                        предварительного уведомления (согласования) Заказчика.
                    </p>
                </li>
                <li>
                    <p>
                        12.7. Стороны, их аффилированные лица, работники, а также посредники и
                        представители, которые прямо или косвенно участвуют в исполнении
                        обязательств Сторонами (в том числе агенты, комиссионеры, таможенные брокеры
                        и иные третьи лица) не принимают, не выплачивают, не предлагают выплатить и
                        не разрешают (санкционируют) выплату/получение каких-либо денежных средств
                        или передачу каких-либо ценностей (в том числе нематериальных) прямо или
                        косвенно, любым лицам, с целью оказания влияния на действия или решения с
                        намерением получить какие-либо неправомерные преимущества, в том числе в
                        обход установленного законодательством порядка, или преследующие иные
                        неправомерные цели. Положения настоящего пункта являются заверениями об
                        обстоятельствах, имеющими для Сторон существенное значение. Стороны
                        полагаются на такие заверения при заключении Договора. В случае
                        возникновения у Стороны подозрений, что произошло или может произойти
                        нарушение каких-либо положений настоящего пункта, соответствующая Сторона
                        обязуется как можно скорее уведомить другую Сторону о своих подозрениях в
                        письменной форме. В случае нарушения одной из Сторон обязательств по
                        соблюдению требований, предусмотренных настоящим пунктом, Сторона вправе
                        немедленно отказаться от Договора в одностороннем внесудебном порядке,
                        направив письменное уведомление о расторжении.
                    </p>
                </li>
            </ol>
            <h2>13. Реквизиты Яндекса</h2>
            <p>Наименование: ООО «Яндекс»</p>
            <p>Адрес места нахождения: 119021, Россия, г. Москва, ул. Льва Толстого, д. 16</p>
            <p>
                Почтовый адрес: 123112, Россия, г. Москва, 1-ый Красногвардейский проезд, дом 21,
                строение 1.
            </p>{' '}
            <p>тел.: (495) 739-70-00</p>
            <p>ОГРН: 1027700229193</p>
            <p>ИНН: 7736207543</p>
            <p>КПП: 997750001</p>
            <p>Банковские реквизиты:</p>
            <p>Расчетный счет 40702810300001003838 в ИНГ БАНК (ЕВРАЗИЯ) АО</p>
            <p>БИК: 044525222 Корреспондентский счет 30101810500000000222</p>
        </div>
    );
}
