#!/usr/bin/env python3

import json
import vault_client
import os

TOKEN = os.getenv("YAV_TOKEN")

if not TOKEN:
    err = "export YAV_TOKEN; Get it here:https://oauth.yandex-team.ru/authorize?response_type=token&client_id=ce68fbebc76c4ffda974049083729982"
    raise RuntimeError(err)


class Role:
    def __init__(self, role, db):
        self.role = role
        self.db = db

    def __repr__(self):
        return {"role": self.role, "db": self.db}


class User:
    def __init__(self, username, roles):
        self.roles = roles
        self.username = username
        self.pwd = self.gen_password

    @property
    def gen_password(self):
        import random
        import string

        passwd = ""
        for i in range(20):
            j = random.randint(0, len(string.ascii_letters) - 1)
            passwd += string.ascii_letters[j]
        return passwd

    def __repr__(self):
        roles = []
        for role in self.roles:
            roles.append(role.__repr__())

        return json.dumps({"user": self.username, "pwd": self.pwd, "roles": roles})


def main():

    blacklist = ["bo"]
    PROD_USERS = "/Users/fedusia/123"
    with open(PROD_USERS, "r") as fd:
        data = json.load(fd)
    users = []
    for user in data["d"]:
        new_roles = [
            Role("clusterMonitor", "admin"),
            Role("changeOwnPassword", "admin"),
        ]
        if user["user"] in blacklist:
            continue
        roles = user["roles"]
        for role in roles:
            if role["role"] in ["read", "readWrite"]:
                new_roles.append(Role(role["role"], "trust"))

        users.append(User(user["user"], new_roles))

    client = vault_client.instances.Production(authorization="Oauth {}".format(TOKEN))
    for user in users:
        secret_uuid = client.create_secret("mongo_pass_{}".format(user.username))
        version_uuid = client.create_secret_version(secret_uuid, {"pass": user.pwd})
        client.add_user_role_to_secret(secret_uuid, "owner", login=user.username)
        print(
            user.username,
            "https://yav.yandex-team.ru/secret/{}/explore/version/{}".format(
                secret_uuid, version_uuid
            ),
        )
    for user in users:
        print("db.createUser({})".format(user))


if __name__ == "__main__":
    main()

