from pipelines_api.launcher import buildLaunchCommand, PipelineLauncher
from pipelines_api.pipes import oebs
from pipelines_api.pipes.resources.event import Event
import json

launcher = PipelineLauncher(endpoint='https://timeline-test.paysys.yandex-team.ru')

res = Event(title="check").as_resource()
command = buildLaunchCommand([], res)


# Launch single job pipeline
print launcher.launch(oebs.project, command)


# Launch start-finish pipe
command = buildLaunchCommand([], res)
result = launcher.launch(oebs.project, command)
# Decoding launchId from result
launch_id = json.loads(result)["pipeLaunchIds"][0]
# Launch "finish" job in pipe. See oebs.jobs for avaliable jobs in pipes
launcher.launch_job(launch_id, "finish")

