import requests, json
from requests.packages.urllib3.exceptions import InsecureRequestWarning
from collections import namedtuple

requests.packages.urllib3.disable_warnings(InsecureRequestWarning)


class LaunchReleaseInput(namedtuple('LaunchReleaseInput', 'disabledManualTriggers resources')):
    __slots__ = ()

    def __new__(cls, triggers, resources):
        return super(LaunchReleaseInput, cls).__new__(cls, triggers, resources)


def buildLaunchCommand(triggers=None, resources=None):
    triggers = triggers if triggers else []
    resources = resources if resources else {}
    return LaunchReleaseInput(triggers, resources)


class PipelineLauncher(object):
    def __init__(self, endpoint='https://timeline-test.paysys.yandex-team.ru', timeout=30):
        self.__endpoint = endpoint
        self.__timeout = timeout

    def _req(self, handler, command=None):
        headers = {"Content-Type": "application/json"}
        data = json.dumps(command._asdict()) if command else None
        req = requests.post(''.join([self.__endpoint, handler]),
                            headers=headers, data=data, verify=False, timeout=self.__timeout)
        try:
            req.raise_for_status()
        except Exception as e:
            return req.text
        return req.text

    def launch(self, project, pipeline, command):
        assert isinstance(project, str) or isinstance(project, unicode)
        assert isinstance(pipeline, str) or isinstance(pipeline, unicode)

        handler = "/api/robot/projects/{0}/releases/launch/{1}".format(project, pipeline)
        result = self._req(handler, command)
        return result

    def launch_job(self, id, job):
        handler = "/api/pipe/launch/robot/{0}/job/{1}/launch".format(id, job)
        result = self._req(handler)
        return result
