_class = "ru.yandex.paysys.timeline.pipelines.notify.resources.Event"
event_resource_uuid = "906567dd-1bf8-45f2-ac85-cd9a541dbdf0"

import calendar
import datetime
import getpass
import socket
import uuid

import pytz
from dateutil import parser


class Event:
    def __init__(self, author=None, text=None, title=None, type="cli-event", status="INFO",
                 start=None, end=None, id=None, tags=None, source=None, project=None):
        self.author = author
        self.text = text
        self.title = title
        self.type = type
        self.status = status
        self.start = start
        self.end = end
        self.id = id
        self.tags = tags
        self.source = source
        self.project = project
        self.id = id
        self.tags = tags
        self.source = source
        self.project = project

    def as_resource(self):
        return {event_resource_uuid: {k: v for k, v in self.__dict__.items() if v is not None}}

    @staticmethod
    def get_builder():
        return Builder


class Builder():
    def __init__(self, args, epoch=False):
        self.__builder = self.__EventBuilder(epoch)
        self.__builder.update(args)
        self.__builder.update_time(args)
        self.__builder.update_status(args)

    def build(self, args=None):
        return self.__builder.build(args)

    class _AbstractBuilder():
        def __init__(self, epoch):
            self.epoch = epoch
            self._args = {
                'tags': None,
                'type': 'pipelines-cli',
                'project': None,
                'source': socket.getfqdn(),
                'text': None
            }

        def update_status(self, args):
            status = args.get('status', 'INFO')
            return self.update({'status': status})

        def _parse_or_now(self, dt=None):
            if dt:
                if self.epoch:
                    dt = datetime.datetime.fromtimestamp(int(dt), pytz.utc)
                else:
                    dt = parser.parse(dt)
                    dt = dt.replace(tzinfo=dt.tzinfo).astimezone(pytz.utc)
            else:
                dt = datetime.datetime.now(pytz.utc)

            return calendar.timegm(dt.timetuple()) * 1000 #java milliseconds

        def update(self, args=None):
            if isinstance(args, dict):
                self._args.update(args)
            return self

    class __EventBuilder(_AbstractBuilder):
        def __init__(self, epoch):
            Builder._AbstractBuilder.__init__(self, epoch)
            self.update({
                'id': 'cli-{}'.format(uuid.uuid4().hex),
                'title': None,
                'author': getpass.getuser()
            })

        def update_time(self, args):
            start = self._parse_or_now(args.get('start'))
            end = self._parse_or_now(args.get('end'))
            if end == start:
                end += 10000
            return self.update({'start': start, 'end': end})

        def build(self, args=None):
            self.update(args)
            return Event(**self._args)
