# solomon-client
No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 2.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen
For more information, please visit [https://wiki.yandex-team.ru/solomon](https://wiki.yandex-team.ru/solomon)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import solomon_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import solomon_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import solomon_client
from solomon_client.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = solomon_client.YasmAlertingApi(solomon_client.ApiClient(configuration))
body = solomon_client.ConvertAlertsRequest() # ConvertAlertsRequest | request

try:
    # Validate and convert Yasm alerts
    api_response = api_instance.convert_using_post(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling YasmAlertingApi->convert_using_post: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *//solomon.yandex-team.ru/*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*YasmAlertingApi* | [**convert_using_post**](docs/YasmAlertingApi.md#convert_using_post) | **POST** /api/v2/yasmAlerts/convert | Validate and convert Yasm alerts
*AlertingApi* | [**create_alert_using_post**](docs/AlertingApi.md#create_alert_using_post) | **POST** /api/v2/projects/{projectId}/alerts | Create new alert
*AlertingApi* | [**create_notification_using_post**](docs/AlertingApi.md#create_notification_using_post) | **POST** /api/v2/projects/{projectId}/notificationChannels | Create new notification channel
*AlertingApi* | [**delete_alert_using_delete**](docs/AlertingApi.md#delete_alert_using_delete) | **DELETE** /api/v2/projects/{projectId}/alerts/{alertId} | Delete alert
*AlertingApi* | [**delete_notification_using_delete**](docs/AlertingApi.md#delete_notification_using_delete) | **DELETE** /api/v2/projects/{projectId}/notificationChannels/{notificationChannelId} | Delete notification
*AlertingApi* | [**explain_evaluation_sub_alert_using_get**](docs/AlertingApi.md#explain_evaluation_sub_alert_using_get) | **GET** /api/v2/projects/{projectId}/alerts/{parentId}/subAlerts/{alertId}/explainEvaluation | Explain evaluation for exist sub alert
*AlertingApi* | [**explain_evaluation_using_get**](docs/AlertingApi.md#explain_evaluation_using_get) | **GET** /api/v2/projects/{projectId}/alerts/{alertId}/explainEvaluation | Explain evaluation for exist alert
*AlertingApi* | [**explain_evaluation_using_post**](docs/AlertingApi.md#explain_evaluation_using_post) | **POST** /api/v2/projects/{projectId}/alerts/explainEvaluation | Explain alert evaluation
*AlertingApi* | [**explain_evaluation_using_post1**](docs/AlertingApi.md#explain_evaluation_using_post1) | **POST** /api/v2/projects/{projectId}/alerts/subAlerts/explainEvaluation | Explain sub-alert evaluation
*AlertingApi* | [**get_alert_evaluation_state_using_get**](docs/AlertingApi.md#get_alert_evaluation_state_using_get) | **GET** /api/v2/projects/{projectId}/alerts/{alertId}/state/evaluation | Get alert evaluation state by id
*AlertingApi* | [**get_alert_notification_state_using_get**](docs/AlertingApi.md#get_alert_notification_state_using_get) | **GET** /api/v2/projects/{projectId}/alerts/{alertId}/state/notification | Get alert notification state by id
*AlertingApi* | [**get_alert_notification_stats_using_get**](docs/AlertingApi.md#get_alert_notification_stats_using_get) | **GET** /api/v2/projects/{projectId}/alerts/{alertId}/state/notificationStats | Get alert notification stats by id
*AlertingApi* | [**get_alert_using_get**](docs/AlertingApi.md#get_alert_using_get) | **GET** /api/v2/projects/{projectId}/alerts/{alertId} | Get alert by id
*AlertingApi* | [**get_multi_alert_evaluation_state_using_get**](docs/AlertingApi.md#get_multi_alert_evaluation_state_using_get) | **GET** /api/v2/projects/{projectId}/alerts/{alertId}/state/evaluationStats | Get alert evaluation stats by id
*AlertingApi* | [**get_notification_using_get**](docs/AlertingApi.md#get_notification_using_get) | **GET** /api/v2/projects/{projectId}/notificationChannels/{notificationChannelId} | Get notification channel by id
*AlertingApi* | [**get_project_stats_using_get**](docs/AlertingApi.md#get_project_stats_using_get) | **GET** /api/v2/projects/{projectId}/alerts/stats | Get project stats
*AlertingApi* | [**get_sub_alert_evaluation_state_using_get**](docs/AlertingApi.md#get_sub_alert_evaluation_state_using_get) | **GET** /api/v2/projects/{projectId}/alerts/{parentId}/subAlerts/{alertId}/state/evaluation | Get sub alert evaluation state by id
*AlertingApi* | [**get_sub_alert_notification_state_using_get**](docs/AlertingApi.md#get_sub_alert_notification_state_using_get) | **GET** /api/v2/projects/{projectId}/alerts/{parentId}/subAlerts/{alertId}/state/notification | Get sub alert notification state by id
*AlertingApi* | [**get_sub_alert_using_get**](docs/AlertingApi.md#get_sub_alert_using_get) | **GET** /api/v2/projects/{projectId}/alerts/{parentId}/subAlerts/{alertId} | Get sub alert by id
*AlertingApi* | [**get_telegram_group_titles_using_get**](docs/AlertingApi.md#get_telegram_group_titles_using_get) | **GET** /api/v2/telegram/groupTitles | Get telegram group titles
*AlertingApi* | [**get_ya_chats_groups_using_get**](docs/AlertingApi.md#get_ya_chats_groups_using_get) | **GET** /api/v2/yaChats/groups | Get Yandex Chats group titles and description
*AlertingApi* | [**list_alerts_by_parent_using_get**](docs/AlertingApi.md#list_alerts_by_parent_using_get) | **GET** /api/v2/projects/{projectId}/alerts/{parentId}/subAlerts | List sub alerts
*AlertingApi* | [**list_alerts_by_project_using_get**](docs/AlertingApi.md#list_alerts_by_project_using_get) | **GET** /api/v2/projects/{projectId}/alerts | List alerts
*AlertingApi* | [**list_notification_using_get**](docs/AlertingApi.md#list_notification_using_get) | **GET** /api/v2/projects/{projectId}/notificationChannels | List notification channels
*AlertingApi* | [**update_alert_using_put**](docs/AlertingApi.md#update_alert_using_put) | **PUT** /api/v2/projects/{projectId}/alerts/{alertId} | Update alert by id
*AlertingApi* | [**update_notification_using_put**](docs/AlertingApi.md#update_notification_using_put) | **PUT** /api/v2/projects/{projectId}/notificationChannels/{notificationChannelId} | Update notification channel by id
*ClustersApi* | [**create_cluster_using_post**](docs/ClustersApi.md#create_cluster_using_post) | **POST** /api/v2/projects/{projectId}/clusters | create cluster
*ClustersApi* | [**delete_cluster_using_delete**](docs/ClustersApi.md#delete_cluster_using_delete) | **DELETE** /api/v2/projects/{projectId}/clusters/{clusterId} | delete cluster
*ClustersApi* | [**get_all_using_get**](docs/ClustersApi.md#get_all_using_get) | **GET** /api/v2/projects/{projectId}/clusters | list available clusters
*ClustersApi* | [**get_cluster_services_using_get**](docs/ClustersApi.md#get_cluster_services_using_get) | **GET** /api/v2/projects/{projectId}/clusters/{clusterId}/services | associated services
*ClustersApi* | [**get_cluster_using_get**](docs/ClustersApi.md#get_cluster_using_get) | **GET** /api/v2/projects/{projectId}/clusters/{clusterId} | read one cluster
*ClustersApi* | [**update_cluster_using_put**](docs/ClustersApi.md#update_cluster_using_put) | **PUT** /api/v2/projects/{projectId}/clusters/{clusterId} | update cluster
*DashboardsApi* | [**create_dashboard_using_post**](docs/DashboardsApi.md#create_dashboard_using_post) | **POST** /api/v2/projects/{projectId}/dashboards | create dashboard
*DashboardsApi* | [**delete_project_using_delete**](docs/DashboardsApi.md#delete_project_using_delete) | **DELETE** /api/v2/projects/{projectId}/dashboards/{dashboardId} | delete dashboard
*DashboardsApi* | [**get_all_using_get1**](docs/DashboardsApi.md#get_all_using_get1) | **GET** /api/v2/projects/{projectId}/dashboards | list available dashboards
*DashboardsApi* | [**get_dashboard_using_get**](docs/DashboardsApi.md#get_dashboard_using_get) | **GET** /api/v2/projects/{projectId}/dashboards/{dashboardId} | read one dashboard
*DashboardsApi* | [**update_dashboard_using_put**](docs/DashboardsApi.md#update_dashboard_using_put) | **PUT** /api/v2/projects/{projectId}/dashboards/{dashboardId} | update dashboard
*DataApi* | [**read_data_from_json_using_post**](docs/DataApi.md#read_data_from_json_using_post) | **POST** /api/v2/projects/{projectId}/sensors/data | compute sensors data
*GraphsApi* | [**create_graph_using_post**](docs/GraphsApi.md#create_graph_using_post) | **POST** /api/v2/projects/{projectId}/graphs | create graph
*GraphsApi* | [**delete_graph_using_delete**](docs/GraphsApi.md#delete_graph_using_delete) | **DELETE** /api/v2/projects/{projectId}/graphs/{graphId} | delete graph
*GraphsApi* | [**get_all_using_get2**](docs/GraphsApi.md#get_all_using_get2) | **GET** /api/v2/projects/{projectId}/graphs | list available graphs
*GraphsApi* | [**get_graph_using_get**](docs/GraphsApi.md#get_graph_using_get) | **GET** /api/v2/projects/{projectId}/graphs/{graphId} | read one graph
*GraphsApi* | [**update_graph_using_put**](docs/GraphsApi.md#update_graph_using_put) | **PUT** /api/v2/projects/{projectId}/graphs/{graphId} | update graph
*ProjectMenusApi* | [**get_project_menu_using_get**](docs/ProjectMenusApi.md#get_project_menu_using_get) | **GET** /api/v2/projects/{projectId}/menu | return project menu
*ProjectMenusApi* | [**save_project_menu_using_post**](docs/ProjectMenusApi.md#save_project_menu_using_post) | **POST** /api/v2/projects/{projectId}/menu | save project menu
*ProjectMenusApi* | [**save_project_menu_using_put**](docs/ProjectMenusApi.md#save_project_menu_using_put) | **PUT** /api/v2/projects/{projectId}/menu | save project menu
*ProjectsApi* | [**all_projects_using_get**](docs/ProjectsApi.md#all_projects_using_get) | **GET** /api/v2/projects | list available projects
*ProjectsApi* | [**create_project_using_post**](docs/ProjectsApi.md#create_project_using_post) | **POST** /api/v2/projects | create project
*ProjectsApi* | [**delete_project_using_delete1**](docs/ProjectsApi.md#delete_project_using_delete1) | **DELETE** /api/v2/projects/{id} | delete project
*ProjectsApi* | [**get_project_using_get**](docs/ProjectsApi.md#get_project_using_get) | **GET** /api/v2/projects/{id} | read one project
*ProjectsApi* | [**update_project_using_put**](docs/ProjectsApi.md#update_project_using_put) | **PUT** /api/v2/projects/{id} | update project
*PushApi* | [**push_using_post**](docs/PushApi.md#push_using_post) | **POST** /api/v2/push | Push sensors data
*SensorsApi* | [**find_all_label_values_in_old_format_using_get**](docs/SensorsApi.md#find_all_label_values_in_old_format_using_get) | **GET** /api/v2/projects/{projectId}/sensors/labels | find all label values by selector query
*SensorsApi* | [**find_label_keys_in_old_format_using_get**](docs/SensorsApi.md#find_label_keys_in_old_format_using_get) | **GET** /api/v2/projects/{projectId}/sensors/names | find label names by selector query
*SensorsApi* | [**find_metric_names_using_get**](docs/SensorsApi.md#find_metric_names_using_get) | **GET** /api/v2/projects/{projectId}/sensors/sensorNames | find all sensor names in project
*SensorsApi* | [**find_sensors_using_get**](docs/SensorsApi.md#find_sensors_using_get) | **GET** /api/v2/projects/{projectId}/sensors | find sensors by selector query
*ServicesApi* | [**create_service_using_post**](docs/ServicesApi.md#create_service_using_post) | **POST** /api/v2/projects/{projectId}/services | create service
*ServicesApi* | [**delete_service_using_delete**](docs/ServicesApi.md#delete_service_using_delete) | **DELETE** /api/v2/projects/{projectId}/services/{serviceId} | delete service
*ServicesApi* | [**get_all_using_get3**](docs/ServicesApi.md#get_all_using_get3) | **GET** /api/v2/projects/{projectId}/services | list available services
*ServicesApi* | [**get_service_clusters_using_get**](docs/ServicesApi.md#get_service_clusters_using_get) | **GET** /api/v2/projects/{projectId}/services/{serviceId}/clusters | associated clusters
*ServicesApi* | [**get_service_using_get**](docs/ServicesApi.md#get_service_using_get) | **GET** /api/v2/projects/{projectId}/services/{serviceId} | read one service
*ServicesApi* | [**update_service_using_put**](docs/ServicesApi.md#update_service_using_put) | **PUT** /api/v2/projects/{projectId}/services/{serviceId} | update service
*ShardsApi* | [**create_shard_using_post**](docs/ShardsApi.md#create_shard_using_post) | **POST** /api/v2/projects/{projectId}/shards | create shard
*ShardsApi* | [**delete_shard_using_delete**](docs/ShardsApi.md#delete_shard_using_delete) | **DELETE** /api/v2/projects/{projectId}/shards/{shardId} | delete shard
*ShardsApi* | [**get_all_using_get4**](docs/ShardsApi.md#get_all_using_get4) | **GET** /api/v2/projects/{projectId}/shards | list available shards
*ShardsApi* | [**get_shard_using_get**](docs/ShardsApi.md#get_shard_using_get) | **GET** /api/v2/projects/{projectId}/shards/{shardId} | read one shard
*ShardsApi* | [**targets_status_using_get**](docs/ShardsApi.md#targets_status_using_get) | **GET** /api/v2/projects/{projectId}/shards/{shardId}/targets | get shard targets statuses
*ShardsApi* | [**update_shard_using_put**](docs/ShardsApi.md#update_shard_using_put) | **PUT** /api/v2/projects/{projectId}/shards/{shardId} | update shard

## Documentation For Models

 - [AclDto](docs/AclDto.md)
 - [AggrRuleDto](docs/AggrRuleDto.md)
 - [Alert](docs/Alert.md)
 - [AlertEvaluationState](docs/AlertEvaluationState.md)
 - [AlertEvaluationStats](docs/AlertEvaluationStats.md)
 - [AlertEvaluationStatusDto](docs/AlertEvaluationStatusDto.md)
 - [AlertExplainEvaluation](docs/AlertExplainEvaluation.md)
 - [AlertListItem](docs/AlertListItem.md)
 - [AlertNotificationState](docs/AlertNotificationState.md)
 - [AlertNotificationStats](docs/AlertNotificationStats.md)
 - [AlertPage](docs/AlertPage.md)
 - [AlertTimeSeries](docs/AlertTimeSeries.md)
 - [AssociatedChannel](docs/AssociatedChannel.md)
 - [ByteString](docs/ByteString.md)
 - [ChannelConfig](docs/ChannelConfig.md)
 - [CloudEmail](docs/CloudEmail.md)
 - [CloudSms](docs/CloudSms.md)
 - [ClusterDto](docs/ClusterDto.md)
 - [ClusterListItemDto](docs/ClusterListItemDto.md)
 - [ClusterServiceAssociationDto](docs/ClusterServiceAssociationDto.md)
 - [ConductorGroupDto](docs/ConductorGroupDto.md)
 - [ConductorTagDto](docs/ConductorTagDto.md)
 - [ConvertAlertResultDto](docs/ConvertAlertResultDto.md)
 - [ConvertAlertsRequest](docs/ConvertAlertsRequest.md)
 - [ConvertAlertsResponseDto](docs/ConvertAlertsResponseDto.md)
 - [DashboardDto](docs/DashboardDto.md)
 - [DashboardListItemDto](docs/DashboardListItemDto.md)
 - [DashboardPanelDto](docs/DashboardPanelDto.md)
 - [DashboardRowDto](docs/DashboardRowDto.md)
 - [DataRequest](docs/DataRequest.md)
 - [DataResult](docs/DataResult.md)
 - [Descriptor](docs/Descriptor.md)
 - [Downsampling](docs/Downsampling.md)
 - [Email](docs/Email.md)
 - [EnumDescriptor](docs/EnumDescriptor.md)
 - [EnumOptions](docs/EnumOptions.md)
 - [EnumValueDescriptor](docs/EnumValueDescriptor.md)
 - [EnumValueOptions](docs/EnumValueOptions.md)
 - [Error](docs/Error.md)
 - [EvaluationStatistics](docs/EvaluationStatistics.md)
 - [FieldDescriptor](docs/FieldDescriptor.md)
 - [FieldOptions](docs/FieldOptions.md)
 - [FileDescriptor](docs/FileDescriptor.md)
 - [FileOptions](docs/FileOptions.md)
 - [GraphDto](docs/GraphDto.md)
 - [GraphElementListDto](docs/GraphElementListDto.md)
 - [GraphListItemDto](docs/GraphListItemDto.md)
 - [InstanceGroupDto](docs/InstanceGroupDto.md)
 - [IntervalModify](docs/IntervalModify.md)
 - [Juggler](docs/Juggler.md)
 - [JugglerCheck](docs/JugglerCheck.md)
 - [LabelNamesResponseDto](docs/LabelNamesResponseDto.md)
 - [LabelValuesDto](docs/LabelValuesDto.md)
 - [LabelValuesResponseDto](docs/LabelValuesResponseDto.md)
 - [MenuItemDto](docs/MenuItemDto.md)
 - [Message](docs/Message.md)
 - [MessageLite](docs/MessageLite.md)
 - [MessageOptions](docs/MessageOptions.md)
 - [Method](docs/Method.md)
 - [MethodDescriptor](docs/MethodDescriptor.md)
 - [MethodOptions](docs/MethodOptions.md)
 - [MetricDto](docs/MetricDto.md)
 - [MetricNamesResponseDto](docs/MetricNamesResponseDto.md)
 - [NamePart](docs/NamePart.md)
 - [NamePartOrBuilder](docs/NamePartOrBuilder.md)
 - [NannyGroupDto](docs/NannyGroupDto.md)
 - [NetworkDto](docs/NetworkDto.md)
 - [NotificationChannel](docs/NotificationChannel.md)
 - [NotificationChannelPage](docs/NotificationChannelPage.md)
 - [NotificationChannelStateDto](docs/NotificationChannelStateDto.md)
 - [NotificationStatistics](docs/NotificationStatistics.md)
 - [OldStatsDto](docs/OldStatsDto.md)
 - [OneofDescriptor](docs/OneofDescriptor.md)
 - [OneofOptions](docs/OneofOptions.md)
 - [PageDto](docs/PageDto.md)
 - [PagedResultDtoClusterListItemDto](docs/PagedResultDtoClusterListItemDto.md)
 - [PagedResultDtoDashboardListItemDto](docs/PagedResultDtoDashboardListItemDto.md)
 - [PagedResultDtoGraphListItemDto](docs/PagedResultDtoGraphListItemDto.md)
 - [PagedResultDtoMetricDto](docs/PagedResultDtoMetricDto.md)
 - [PagedResultDtoServiceListItemDto](docs/PagedResultDtoServiceListItemDto.md)
 - [PagedResultDtoShardListItemDto](docs/PagedResultDtoShardListItemDto.md)
 - [PagedResultDtoShardTargetStatusDto](docs/PagedResultDtoShardTargetStatusDto.md)
 - [Parser](docs/Parser.md)
 - [ParserEnumOptions](docs/ParserEnumOptions.md)
 - [ParserEnumValueOptions](docs/ParserEnumValueOptions.md)
 - [ParserFieldOptions](docs/ParserFieldOptions.md)
 - [ParserFileOptions](docs/ParserFileOptions.md)
 - [ParserMessage](docs/ParserMessage.md)
 - [ParserMessageLite](docs/ParserMessageLite.md)
 - [ParserMessageOptions](docs/ParserMessageOptions.md)
 - [ParserMethodOptions](docs/ParserMethodOptions.md)
 - [ParserNamePart](docs/ParserNamePart.md)
 - [ParserOneofOptions](docs/ParserOneofOptions.md)
 - [ParserServiceOptions](docs/ParserServiceOptions.md)
 - [ParserTYaChatsGroupInfo](docs/ParserTYaChatsGroupInfo.md)
 - [ParserUninterpretedOption](docs/ParserUninterpretedOption.md)
 - [PatternDto](docs/PatternDto.md)
 - [PredicateRule](docs/PredicateRule.md)
 - [PriorityRuleDto](docs/PriorityRuleDto.md)
 - [ProjectDto](docs/ProjectDto.md)
 - [ProjectMenuDto](docs/ProjectMenuDto.md)
 - [ProjectStatistics](docs/ProjectStatistics.md)
 - [PushResultDto](docs/PushResultDto.md)
 - [QloudGroupDto](docs/QloudGroupDto.md)
 - [QuotasDto](docs/QuotasDto.md)
 - [SelectorListDto](docs/SelectorListDto.md)
 - [ServiceDescriptor](docs/ServiceDescriptor.md)
 - [ServiceDto](docs/ServiceDto.md)
 - [ServiceListItemDto](docs/ServiceListItemDto.md)
 - [ServiceMetricConfDto](docs/ServiceMetricConfDto.md)
 - [ServiceOptions](docs/ServiceOptions.md)
 - [ShardDto](docs/ShardDto.md)
 - [ShardListItemDto](docs/ShardListItemDto.md)
 - [ShardTargetStatusDto](docs/ShardTargetStatusDto.md)
 - [ShardTargetStatusDtoPage](docs/ShardTargetStatusDtoPage.md)
 - [Sms](docs/Sms.md)
 - [SubAlert](docs/SubAlert.md)
 - [SubAlertListItem](docs/SubAlertListItem.md)
 - [SubAlertPage](docs/SubAlertPage.md)
 - [TExpression](docs/TExpression.md)
 - [TYaChatsGroupInfo](docs/TYaChatsGroupInfo.md)
 - [Telegram](docs/Telegram.md)
 - [TelegramGroupTitlesResponseDto](docs/TelegramGroupTitlesResponseDto.md)
 - [Threshold](docs/Threshold.md)
 - [Timeseries](docs/Timeseries.md)
 - [Type](docs/Type.md)
 - [UninterpretedOption](docs/UninterpretedOption.md)
 - [UninterpretedOptionOrBuilder](docs/UninterpretedOptionOrBuilder.md)
 - [UnknownFieldSet](docs/UnknownFieldSet.md)
 - [UrlDto](docs/UrlDto.md)
 - [ValueModify](docs/ValueModify.md)
 - [Values](docs/Values.md)
 - [Webhook](docs/Webhook.md)
 - [YaChats](docs/YaChats.md)
 - [YaChatsGroupsResponseDto](docs/YaChatsGroupsResponseDto.md)
 - [YasmAlertDto](docs/YasmAlertDto.md)
 - [YpDto](docs/YpDto.md)

## Documentation For Authorization

 All endpoints do not require authorization.


## Author

solomon@yandex-team.ru
