# coding: utf-8

"""
    Solomon API v2.0

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 2.0
    Contact: solomon@yandex-team.ru
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from solomon_client.api_client import ApiClient


class GraphsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_graph_using_post(self, body, project_id, **kwargs):  # noqa: E501
        """create graph  # noqa: E501

        This action will save graph document if there is no already existed graph with given id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_graph_using_post(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GraphDto body: graph (required)
        :param str project_id: projectId (required)
        :return: GraphDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_graph_using_post_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_graph_using_post_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def create_graph_using_post_with_http_info(self, body, project_id, **kwargs):  # noqa: E501
        """create graph  # noqa: E501

        This action will save graph document if there is no already existed graph with given id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_graph_using_post_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GraphDto body: graph (required)
        :param str project_id: projectId (required)
        :return: GraphDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_graph_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_graph_using_post`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `create_graph_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/projects/{projectId}/graphs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GraphDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_graph_using_delete(self, graph_id, project_id, **kwargs):  # noqa: E501
        """delete graph  # noqa: E501

        This action will delete already existed graph.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_graph_using_delete(graph_id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str graph_id: graphId (required)
        :param str project_id: projectId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_graph_using_delete_with_http_info(graph_id, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_graph_using_delete_with_http_info(graph_id, project_id, **kwargs)  # noqa: E501
            return data

    def delete_graph_using_delete_with_http_info(self, graph_id, project_id, **kwargs):  # noqa: E501
        """delete graph  # noqa: E501

        This action will delete already existed graph.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_graph_using_delete_with_http_info(graph_id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str graph_id: graphId (required)
        :param str project_id: projectId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['graph_id', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_graph_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'graph_id' is set
        if ('graph_id' not in params or
                params['graph_id'] is None):
            raise ValueError("Missing the required parameter `graph_id` when calling `delete_graph_using_delete`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `delete_graph_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'graph_id' in params:
            path_params['graphId'] = params['graph_id']  # noqa: E501
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/projects/{projectId}/graphs/{graphId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_using_get2(self, project_id, **kwargs):  # noqa: E501
        """list available graphs  # noqa: E501

        This action returns project's graphs if user have permissions to read that project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_using_get2(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: projectId (required)
        :param Ref page: page number (starting from 0)
        :param Ref page_size: page size
        :param str text: text filter by id
        :return: PagedResultDtoGraphListItemDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_using_get2_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_using_get2_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def get_all_using_get2_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """list available graphs  # noqa: E501

        This action returns project's graphs if user have permissions to read that project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_using_get2_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: projectId (required)
        :param Ref page: page number (starting from 0)
        :param Ref page_size: page size
        :param str text: text filter by id
        :return: PagedResultDtoGraphListItemDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'page', 'page_size', 'text']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_using_get2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_all_using_get2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'text' in params:
            query_params.append(('text', params['text']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/projects/{projectId}/graphs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultDtoGraphListItemDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_graph_using_get(self, graph_id, project_id, **kwargs):  # noqa: E501
        """read one graph  # noqa: E501

        This action returns single project's graph found by given graphId.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_graph_using_get(graph_id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str graph_id: graphId (required)
        :param str project_id: projectId (required)
        :return: GraphDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_graph_using_get_with_http_info(graph_id, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_graph_using_get_with_http_info(graph_id, project_id, **kwargs)  # noqa: E501
            return data

    def get_graph_using_get_with_http_info(self, graph_id, project_id, **kwargs):  # noqa: E501
        """read one graph  # noqa: E501

        This action returns single project's graph found by given graphId.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_graph_using_get_with_http_info(graph_id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str graph_id: graphId (required)
        :param str project_id: projectId (required)
        :return: GraphDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['graph_id', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_graph_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'graph_id' is set
        if ('graph_id' not in params or
                params['graph_id'] is None):
            raise ValueError("Missing the required parameter `graph_id` when calling `get_graph_using_get`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_graph_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'graph_id' in params:
            path_params['graphId'] = params['graph_id']  # noqa: E501
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/projects/{projectId}/graphs/{graphId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GraphDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_graph_using_put(self, body, graph_id, project_id, **kwargs):  # noqa: E501
        """update graph  # noqa: E501

        This action will update already existed project's graph with given document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_graph_using_put(body, graph_id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GraphDto body: graph (required)
        :param str graph_id: graphId (required)
        :param str project_id: projectId (required)
        :return: GraphDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_graph_using_put_with_http_info(body, graph_id, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_graph_using_put_with_http_info(body, graph_id, project_id, **kwargs)  # noqa: E501
            return data

    def update_graph_using_put_with_http_info(self, body, graph_id, project_id, **kwargs):  # noqa: E501
        """update graph  # noqa: E501

        This action will update already existed project's graph with given document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_graph_using_put_with_http_info(body, graph_id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GraphDto body: graph (required)
        :param str graph_id: graphId (required)
        :param str project_id: projectId (required)
        :return: GraphDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'graph_id', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_graph_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_graph_using_put`")  # noqa: E501
        # verify the required parameter 'graph_id' is set
        if ('graph_id' not in params or
                params['graph_id'] is None):
            raise ValueError("Missing the required parameter `graph_id` when calling `update_graph_using_put`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `update_graph_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'graph_id' in params:
            path_params['graphId'] = params['graph_id']  # noqa: E501
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/projects/{projectId}/graphs/{graphId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GraphDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
