# coding: utf-8

"""
    Solomon API v2.0

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 2.0
    Contact: solomon@yandex-team.ru
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from solomon_client.api_client import ApiClient


class ShardsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_shard_using_post(self, body, project_id, **kwargs):  # noqa: E501
        """create shard  # noqa: E501

        This action will save shard document if there is no already existed shard with given id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_shard_using_post(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ShardDto body: shard (required)
        :param str project_id: projectId (required)
        :return: ShardDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_shard_using_post_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_shard_using_post_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def create_shard_using_post_with_http_info(self, body, project_id, **kwargs):  # noqa: E501
        """create shard  # noqa: E501

        This action will save shard document if there is no already existed shard with given id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_shard_using_post_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ShardDto body: shard (required)
        :param str project_id: projectId (required)
        :return: ShardDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_shard_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_shard_using_post`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `create_shard_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/projects/{projectId}/shards', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ShardDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_shard_using_delete(self, project_id, shard_id, **kwargs):  # noqa: E501
        """delete shard  # noqa: E501

        This action will delete already existed shard.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_shard_using_delete(project_id, shard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: projectId (required)
        :param str shard_id: shardId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_shard_using_delete_with_http_info(project_id, shard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_shard_using_delete_with_http_info(project_id, shard_id, **kwargs)  # noqa: E501
            return data

    def delete_shard_using_delete_with_http_info(self, project_id, shard_id, **kwargs):  # noqa: E501
        """delete shard  # noqa: E501

        This action will delete already existed shard.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_shard_using_delete_with_http_info(project_id, shard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: projectId (required)
        :param str shard_id: shardId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'shard_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_shard_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `delete_shard_using_delete`")  # noqa: E501
        # verify the required parameter 'shard_id' is set
        if ('shard_id' not in params or
                params['shard_id'] is None):
            raise ValueError("Missing the required parameter `shard_id` when calling `delete_shard_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501
        if 'shard_id' in params:
            path_params['shardId'] = params['shard_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/projects/{projectId}/shards/{shardId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_using_get4(self, project_id, **kwargs):  # noqa: E501
        """list available shards  # noqa: E501

        This action returns project's shards if user have permissions to read that project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_using_get4(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: projectId (required)
        :param Ref page: page number (starting from 0)
        :param Ref page_size: page size
        :param str state: state
        :param str text: text
        :return: PagedResultDtoShardListItemDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_using_get4_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_using_get4_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def get_all_using_get4_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """list available shards  # noqa: E501

        This action returns project's shards if user have permissions to read that project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_using_get4_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: projectId (required)
        :param Ref page: page number (starting from 0)
        :param Ref page_size: page size
        :param str state: state
        :param str text: text
        :return: PagedResultDtoShardListItemDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'page', 'page_size', 'state', 'text']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_using_get4" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_all_using_get4`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'text' in params:
            query_params.append(('text', params['text']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/projects/{projectId}/shards', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultDtoShardListItemDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shard_using_get(self, project_id, shard_id, **kwargs):  # noqa: E501
        """read one shard  # noqa: E501

        This action returns single project's shard found by given shardId.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shard_using_get(project_id, shard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: projectId (required)
        :param str shard_id: shardId (required)
        :return: ShardDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_shard_using_get_with_http_info(project_id, shard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_shard_using_get_with_http_info(project_id, shard_id, **kwargs)  # noqa: E501
            return data

    def get_shard_using_get_with_http_info(self, project_id, shard_id, **kwargs):  # noqa: E501
        """read one shard  # noqa: E501

        This action returns single project's shard found by given shardId.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shard_using_get_with_http_info(project_id, shard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: projectId (required)
        :param str shard_id: shardId (required)
        :return: ShardDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'shard_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shard_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_shard_using_get`")  # noqa: E501
        # verify the required parameter 'shard_id' is set
        if ('shard_id' not in params or
                params['shard_id'] is None):
            raise ValueError("Missing the required parameter `shard_id` when calling `get_shard_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501
        if 'shard_id' in params:
            path_params['shardId'] = params['shard_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/projects/{projectId}/shards/{shardId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ShardDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def targets_status_using_get(self, project_id, shard_id, **kwargs):  # noqa: E501
        """get shard targets statuses  # noqa: E501

        This action will retrieve paged list of statuses of pulled shard targets by particular Solomon Fetcher host.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.targets_status_using_get(project_id, shard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: projectId (required)
        :param str shard_id: shardId (required)
        :param str dc: dc
        :param str fetcher_host: fetcherHost
        :param str host_glob: hostGlob
        :param str status: status
        :return: ShardTargetStatusDtoPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.targets_status_using_get_with_http_info(project_id, shard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.targets_status_using_get_with_http_info(project_id, shard_id, **kwargs)  # noqa: E501
            return data

    def targets_status_using_get_with_http_info(self, project_id, shard_id, **kwargs):  # noqa: E501
        """get shard targets statuses  # noqa: E501

        This action will retrieve paged list of statuses of pulled shard targets by particular Solomon Fetcher host.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.targets_status_using_get_with_http_info(project_id, shard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: projectId (required)
        :param str shard_id: shardId (required)
        :param str dc: dc
        :param str fetcher_host: fetcherHost
        :param str host_glob: hostGlob
        :param str status: status
        :return: ShardTargetStatusDtoPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'shard_id', 'dc', 'fetcher_host', 'host_glob', 'status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method targets_status_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `targets_status_using_get`")  # noqa: E501
        # verify the required parameter 'shard_id' is set
        if ('shard_id' not in params or
                params['shard_id'] is None):
            raise ValueError("Missing the required parameter `shard_id` when calling `targets_status_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501
        if 'shard_id' in params:
            path_params['shardId'] = params['shard_id']  # noqa: E501

        query_params = []
        if 'dc' in params:
            query_params.append(('dc', params['dc']))  # noqa: E501
        if 'fetcher_host' in params:
            query_params.append(('fetcherHost', params['fetcher_host']))  # noqa: E501
        if 'host_glob' in params:
            query_params.append(('hostGlob', params['host_glob']))  # noqa: E501
        if 'status' in params:
            query_params.append(('status', params['status']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/projects/{projectId}/shards/{shardId}/targets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ShardTargetStatusDtoPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_shard_using_put(self, body, project_id, shard_id, **kwargs):  # noqa: E501
        """update shard  # noqa: E501

        This action will update already existed project's shard with given document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_shard_using_put(body, project_id, shard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ShardDto body: shard (required)
        :param str project_id: projectId (required)
        :param str shard_id: shardId (required)
        :return: ShardDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_shard_using_put_with_http_info(body, project_id, shard_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_shard_using_put_with_http_info(body, project_id, shard_id, **kwargs)  # noqa: E501
            return data

    def update_shard_using_put_with_http_info(self, body, project_id, shard_id, **kwargs):  # noqa: E501
        """update shard  # noqa: E501

        This action will update already existed project's shard with given document.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_shard_using_put_with_http_info(body, project_id, shard_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ShardDto body: shard (required)
        :param str project_id: projectId (required)
        :param str shard_id: shardId (required)
        :return: ShardDto
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id', 'shard_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_shard_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_shard_using_put`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `update_shard_using_put`")  # noqa: E501
        # verify the required parameter 'shard_id' is set
        if ('shard_id' not in params or
                params['shard_id'] is None):
            raise ValueError("Missing the required parameter `shard_id` when calling `update_shard_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501
        if 'shard_id' in params:
            path_params['shardId'] = params['shard_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/projects/{projectId}/shards/{shardId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ShardDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
