package helpers

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"log"
	"net/http"
)

type ABCClient struct {
	Token string
	Host  string
}

type Shift struct {
	End           string   `json:"end"`
	IsApproved    bool     `json:"is_approved"`
	Start         string   `json:"start"`
	ProblemsCount int64    `json:"problems_count"`
	ID            int64    `json:"id"`
	Person        Person   `json:"person"`
	Schedule      Schedule `json:"schedule"`
}

type Schedule struct {
}

type Person struct {
	Login string `json:"login"`
}

func NewABCClient(token string, host string) *ABCClient {
	if token == "" {
		log.Fatalln("ABCToken variable is not set")
	}
	client := &ABCClient{token, host}
	return client

}

func (c *ABCClient) OnDuty(serviceID int64) (staffLogin string) {
	var shifts []Shift
	url := fmt.Sprintf("https://%s/api/v3/services/%d/on_duty/", c.Host, serviceID)
	client := http.Client{}
	req, err := http.NewRequest("GET", url, nil)
	if err != nil {
		log.Fatalln("Failed to create request: ", err)
	}
	req.Header.Add("Authorization", "OAuth "+c.Token)
	resp, err := client.Do(req)
	if err != nil {
		log.Fatalln(err)
	}
	if resp.StatusCode != 200 {
		log.Println("Check oath settings:", c.Host)
		log.Fatalf("HTTP Answer %d from %s", resp.StatusCode, c.Host)
	}
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		log.Fatalf("Failed to decode body: %v", err)
	}
	err = json.Unmarshal(body, &shifts)
	if err != nil {
		log.Fatalln("Failed to parse response from api:", err)
	}
	staffLogin = shifts[0].Person.Login
	return staffLogin
}
