package helpers

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"log"
	"net/http"
)

type StaffClient struct {
	Token string
	Host  string
}

type StaffAccounts struct {
	Result []Accounts `json:"result"`
}

type Accounts struct {
	Account []Account `json:"accounts"`
}
type Account struct {
	Value      string `json:"value"`
	Type       string `json:"type"`
	Private    bool   `json:"private"`
	ValueLower string `json:"value_lower"`
	ID         int64  `json:"id"`
}

func NewStaffClient(token string, host string) *StaffClient {
	if token == "" {
		log.Fatalln("STAFFToken variable is not set")
	}
	client := &StaffClient{token, host}
	return client
}

func (c *StaffClient) GetTelegramLogin(staffLogin string) (telegramLogin string) {
	url := fmt.Sprintf("https://%s/v3/persons?_pretty=1&login=%s&_fields=accounts", c.Host, staffLogin)
	client := http.Client{}
	req, err := http.NewRequest("GET", url, nil)
	if err != nil {
		log.Fatalln("Failed to create requrest: ", err)
	}
	req.Header.Add("Authorization", "OAuth "+c.Token)
	res, err := client.Do(req)
	if err != nil {
		log.Println("Failed perform requests: ", err)
	}

	body, _ := ioutil.ReadAll(res.Body)
	if res.StatusCode != 200 {
		log.Println("body: ", string(body))
		log.Fatalf("HTTP Answer %d from %s", res.StatusCode, c.Host)
	}
	accounts := StaffAccounts{}
	err = json.Unmarshal(body, &accounts)
	if err != nil {
		log.Println("Failed to parse response: ", err)
	}
	for _, s := range accounts.Result[0].Account {
		if s.Type == "telegram" {
			telegramLogin = "@" + s.ValueLower
			break
		}
	}
	return telegramLogin
}
