package main

import (
	"a.yandex-team.ru/paysys/sre/apps/paysysbot/helpers"
	"encoding/json"
	"fmt"
	"io/ioutil"
	"log"
	"net/http"
	"os"
	"strings"
	"time"
)

// TODO: move telegram api to separate file
// TODO: add /ping

type sendMessageResponse struct {
	Ok     bool    `json:"ok"`
	Result Message `json:"result"`
}
type getUpdatesResponse struct {
	Ok     bool     `json:"ok"`
	Result []Update `json:"result"`
}

type User struct {
	ID        int64  `json:"id"`
	IsBot     bool   `json:"is_bot"`
	FirstName string `json:"first_name"`
	UserName  string `json:"username"`
}

type Chat struct {
	ID        int64  `json:"id"`
	Title     string `json:"title"`
	Type      string `json:"type"`
	AllAdmins bool   `json:"all_members_are_administrators"`
}

type Message struct {
	MessageID   int   `json:"message_id"`
	From        User  `json:"from,omitempty"`
	Date        int64 `json:"date"`
	Chat        Chat  `json:"chat"`
	ForwardFrom User  `json:"forward_from,omitempty"`
	ForwardDate int64 `json:"forward_date,omitempty"`
	// ReplyToMessage Message `json:"reply_to_message"`
	Text string `json:"text,omitempty"`
}

type Update struct {
	UpdateID            int64               `json:"update_id"`
	Message             Message             `json:"message,omitempty"`
	InlineQuery         InlineQuery         `json:"inline_query,omitempty"`
	ChoosenInlineResult ChoosenInlineResult `json:"chosen_inline_result,omitempty"`
	CallbackQuery       CallbackQuery       `json:"callback_query,omitempty"`
}

type InlineQuery struct {
}
type ChoosenInlineResult struct {
}
type CallbackQuery struct {
}

type TelegramClient struct {
	Token string
	Host  string
}

func NewTelegramClient(token string, host string) *TelegramClient {
	if token == "" {
		log.Fatalln("TelegramBotToken variable is not set")
	}
	client := &TelegramClient{token, host}
	return client
}

func (c *TelegramClient) sendMessage(message string) {
	chatID := -398038984
	url := fmt.Sprintf("https://%s/%s/sendMessage?chat_id=%d&text=%s", c.Host, c.Token, chatID, message)
	r, err := http.Get(url)
	if err != nil {
		log.Println(err)
	}
	b, err := ioutil.ReadAll(r.Body)
	if err != nil {
		log.Println("Failed to parse body: ", err)
	}
	if r.StatusCode != 200 {
		log.Println("StatusCode: ", r.StatusCode)
		log.Println("Response: ", string(b))
	}
	resp := sendMessageResponse{}
	err = json.Unmarshal(b, &resp)
	if err != nil {
		log.Println("Failed to parse response body: ", err)
	}
	log.Println(resp.Ok)
	log.Println(resp.Result.MessageID)

}
func (c *TelegramClient) getUpdates() {
	var (
		offset, serviceID int64
		abc               *helpers.ABCClient
		staff             *helpers.StaffClient
	)

	serviceID = 1996
	abc = helpers.NewABCClient(os.Getenv("ABCToken"), "abc-back.yandex-team.ru")
	staff = helpers.NewStaffClient(os.Getenv("STAFFToken"), "staff-api.yandex-team.ru")
	for {
		url := fmt.Sprintf("https://%s/%s/getUpdates?limit=1&offset=%d", c.Host, c.Token, offset)
		log.Println(url)
		r, err := http.Get(url)
		if err != nil {
			log.Fatal(err)
		}
		body, err := ioutil.ReadAll(r.Body)
		if err != nil {
			log.Fatal(err)
		}

		if r.StatusCode == 404 {
			log.Println("Check bot token")
		}
		log.Printf("Response: %s", string(body))

		response := getUpdatesResponse{}
		err = json.Unmarshal(body, &response)
		if err != nil {
			log.Fatal(err)
		}
		if len(response.Result) > 0 {
			message := response.Result[0].Message.Text
			if strings.Contains(message, "/админ") {
				duty := abc.OnDuty(serviceID)
				telegram := staff.GetTelegramLogin(duty)

				message = strings.Replace(message, "/админ", telegram, 1)
				go c.sendMessage(message)
			}
			offset = response.Result[0].UpdateID + 1
		}

		log.Printf("Telegram UpdateID offset: %d", offset)
		time.Sleep(5 * time.Second)
	}
}

func main() {
	client := NewTelegramClient(os.Getenv("TelegramBotToken"), "api.telegram.org")
	client.getUpdates()
}
