# Сервис рассылок писем менеджерам

#### Что это и зачем?
- Оповещение менеджеров о состоянии договоров, контрактов. Получение менеджерами различных документов. Информирование о
  задолжностях или наступления срока пролонгации.
- Сервис призван заменить собой существующие рассылки живущие внутри _Oracle_. Это нужно для выделения компоненты в
  отдельный микросервис в связи со съездом с _Oracle_. Так же это необходима для актуализации самих рассылок.

#### Из чего состоит, где работает?
- Сервис состоит из модулей написанных на _python_, код хостится в Аркадии.
- Конфиги описывающие бизнес логику рассылки, хранятся в Бункере.
- Рассылка писем осуществляется через Рассылятор. Письма в очереди рассылятора, хранятся неделю, для проверки статуса
  отправки.
- Задействованная инфраструктура: Бункер, Реактор, Нирвана, Рассылятор, Конструкто писем.

#### ABC сервиса: https://abc.yandex-team.ru/services/balance_mailing
<br/>

## Компоненты сервиса:

### - Модуль работы с конфигами в бункере
Тексты запросов YQL и другие параметры хранятся в конфигах в бункере. Этот модуль выполняет поиск нужного конфига,
подготавливает JSON и передает его модулю выполнения YQL запросов.
Каждая рассылка имеет свой собственный конфиг. <br/>

Поля указанные в YQL запросе это шаблоны которые будут подставлены в Jinja2 в тело письма в рассыляторе. <br/>
Обязательно должны быть заполнены либо поле _to:_ в конфиге, либо присутствовать шаблон _email_ в запросе YQL. <br/>
Пример с шаблоном email: https://bunker.yandex-team.ru/balance-notifier/prod/contract_notify <br/>
Пример с полем to: https://bunker.yandex-team.ru/balance-notifier/prod/signed_notify

### - Модуль работы с YT, чтение/запись данных
Выполнение запросов YQL полученных из предыдущего модуля. Выполненный результат запроса сохраняется в YT таблицу с
уникальным message_id для каждой строки. Каждая строка в таблице это одно письмо на отправку. Таблица уникальна в
пределах суток. При перезапуске операции и условии, что таблица существует, данные не перевыгружаются.

### - Модуль работы с API рассылятора
Читаются строки из таблицы сохраненной предыдущим модулем. Проверяется статус каждого письма на код ответа _SMTP 250_
(Requested mail action okay, completed). Если код ответа отличен от _SMTP 250_, письмо посылается еще раз.
<br/>
<br/>
## Внешние компоненты по отношению к сервису:

### - Бункер
PROD: https://bunker.yandex-team.ru/balance-notifier/prod <br/>
TEST: https://bunker.yandex-team.ru/balance-notifier/test <br/>

### - Нирвана
PROD: https://test.nirvana.yandex-team.ru/browse?selected=17347821 <br/>
TEST: https://nirvana.yandex-team.ru/browse?selected=9140058 <br/>

### - Реактор
PROD: https://test.nirvana.yandex-team.ru/browse?selected=17347821 <br/>
TEST: https://nirvana.yandex-team.ru/browse?selected=9140058 <br/>

### - Рассылятор
PROD: https://sender.yandex-team.ru/yandex.balance/campaign/transact <br/>
TEST: https://test.sender.yandex-team.ru/yandex.balance/campaign/transact <br/>

### - Конструктор писем
https://lpc.yandex-team.ru/finder-emc/.sandbox-mail/balance-notifier
<br/>
<br/>
## Что нужно для того, чтобы завести новую рассылку:

1. Создать шаблон письма в конструкторе писем, по имени рассылки. Разместить необходимый статический текст.
   Описать логику развертывания шаблонов Jinja2 внутри тела письма.
2. Создать транзакционную рассылку в рассыляторе, по имени рассылки. Заполнить все необходимые поля.
   Тема, от кого. Загрузить, ранее созданный, шаблон письма из конструктора. Включить рассылку.
3. Создать конфиг в бункере по имени рассылки.
   - В тексте запроса указать YQL запрос логики рассылки, имена колонок это
   шаблоны которые должны быть указаны в Jinja2 в рассыляторе. Они могут быть любыми.
   - В идентификаторе рассылки указать ссылку на рассылку из рассылятора, без команды "/send".
   - Тип запроса YQL.
   - to, может быть пустым, при условии присутствия поля email в теле запроса YQL.
   - cc, может быть пустым.
   - bcc, может быть пустым.
4. Создать задачу в реакторе с расписанием запуска рассылки.
   - cron
   - Inputs -> Blocks parameters -> read_bunker_config (environment, log_level, nodes (имя конфига в бункере))
   - Notifications
