# https://a.yandex-team.ru/arc/trunk/arcadia/billing/yandex_pay/tools/juggler/bundle/checks_bin/entrypoint.py

import os

from juggler import bundles

from paysys_sre_juggler_checks_bundle_checks.unispace import Unispace  # noqa


def create_manifest() -> bundles.Manifest:
    manifest = bundles.Manifest()

    manifest.register(Unispace(
        paths=os.getenv('PATHS', '/').split(','),
        ignore_non_existing_paths=True,
        warn_usage=float(os.getenv('WARN', Unispace.DEFAULT_USAGE_WARN)),
        crit_usage=float(os.getenv('CRIT', Unispace.DEFAULT_USAGE_CRIT)),
    ).as_check_function())

    return manifest


def main() -> None:
    """
    Запустить проверку руками:
        ./juggler-checks-bundle --execute-check=<check_name>
    Задача сборки бандла (тип задачи BUILD_JUGGLER_CHECKS_BUNDLE) использует вызов
        ./juggler-checks-bundle --show-manifest
    чтобы обогатить MANIFEST.json списком проверок (настройка манифеста `discover_from_executable`).
    """
    bundles.cli(obj=create_manifest())
