#!/bin/bash

function test_expiration {
    EXPIREDATE_UNIX_TIMESTAMP=$1
    FILENAME=$2
    EXPIREDATE=$(date -d @${EXPIREDATE_UNIX_TIMESTAMP})
    CURRENT_TIME_UNIX_TIMESTAMP=$(date +%s)
    let "TIME_DELTA = $EXPIREDATE_UNIX_TIMESTAMP - $CURRENT_TIME_UNIX_TIMESTAMP"
    let "THRESHOLD = 60 * 60 * 24 * 30"
    if test $TIME_DELTA -lt 0
    then
        echo "2;${FILENAME} has expired at ${EXPIREDATE}"
        exit
    fi
    if test $TIME_DELTA -lt $THRESHOLD
    then
        echo "2;${FILENAME} is expiring at ${EXPIREDATE}"
        exit
    fi
}

# Check TLS certs
for cert in $(
    find /etc/postfix/ \
         /etc/yandex/ \
         /etc/nginx/cert/ \
         /etc/nginx/ssl/ \
         /var/lib/yandex/cert \
         -regex '.*\.\(cer\|pem\|crt\)' 2>/dev/null
)
do
    if ! openssl x509 -noout -in ${cert} 2>/dev/null
    then
        continue
    fi
    EXPIREDATE="$(openssl x509 -enddate -noout -in ${cert} 2>/dev/null | \
        sed 's/notAfter=//')"
    EXPIREDATE_UNIX_TIMESTAMP=$(date -d "${EXPIREDATE}" +%s)
    test_expiration ${EXPIREDATE_UNIX_TIMESTAMP} ${cert}
done

# Check GPG keys
for key in $(find /etc/yandex/ -regex '.*\.gpg' 2>/dev/null)
do
    if ! gpg ${key} >/dev/null 2>&1
    then
        continue
    fi
    OLD_IFS=$IFS
    IFS=$'\n'
    for line in $(gpg --with-colons ${key} 2>/dev/null)
    do
        EXPIRE_UNIX_TIMESTAMP="$(echo ${line} | cut -f 7 -d ':')"
        if [ "x${EXPIRE_UNIX_TIMESTAMP}" != "x" ]
        then
            test_expiration ${EXPIRE_UNIX_TIMESTAMP} ${key}
        else
            continue
        fi
    done
    IFS=${OLD_IFS}
done

echo "0;Ok"
