#!/usr/bin/env python
from __future__ import division
import requests
from psadmin import base
import argparse


def parse_args():
    parser = argparse.ArgumentParser(
        description="MDS unispace checker"
    )

    parser.add_argument(
        "mds_type",
        choices=["test_mds", "prod_mds"],
        help="Name of MDS installation"
    )

    parser.add_argument(
        "namespace",
        action="store",
        help="Name of MDS namespace"
    )

    parser.add_argument(
        "threshold",
        action="store",
        help="threshold when checks status turns to CRIT"
    )

    return base.finalize_argparser(parser)


def main():
    mds_installation = {
        "test_mds": "storage-int.mdst.yandex.net",
        "prod_mds": "storage-int.mds.yandex.net"
    }
    args = parse_args()

    status = 0
    message = None
    check_name = 'mds_unispace'

    namespace = args.namespace
    host = mds_installation[args.mds_type]
    threshold = int(args.threshold)

    try:
        r = requests.get('https://{}/statistics-{}'.format(host, namespace))
        r.raise_for_status()
        resp = r.json()
    except Exception:
        status = 2
        message = "Something went wrong, run check manualy and fix problem"
        return base.monrun_output(check_name, status, message)

    free_space = int(resp['free_space']/resp['total_space'] * 100)
    message = '{}: {}% free space'.format(namespace, free_space)
    if free_space < threshold:
        status = 2
        message = "Too low free space: {} for namespace: {}".format(
            free_space,
            namespace
        )

    return base.monrun_output(check_name, status, message)


if __name__ == '__main__':
    main()
