#!/usr/bin/env python

import argparse
import json

from psadmin import base

CMD_BIN = '/usr/bin/push-client'
CONFIG = '/etc/yandex/statbox-push-client/push-client.yaml'
PARAMS = {
    '--check:send-time': 900,
    '--check:commit-time': 900,
    '--check:lag-size': 10000000
}

PARAMS = ' '.join(['{}={}'.format(k, v) for k, v in PARAMS.items()])

name = base.get_name()
log = base.log_file(name)


def parse_args():
    parser = argparse.ArgumentParser(
        description='Send balance metrics to graphite'
    )
    return base.finalize_argparser(parser)


def main():
    parse_args()
    check, code, message = ('pushclient_check', 0, 'OK')
    COMMAND = ' '.join([CMD_BIN, PARAMS, '-c', CONFIG, '--status', '--json'])
    output, _, _ = base.run_shell_get_output(COMMAND)
    output = json.loads(output)

    result = {}
    for log_file in output:
        errors = [e.encode('UTF-8') for e in log_file['errors']]
        if errors:
            result[log_file["name"].encode('UTF-8')] = errors

    if result:
        code, message = 2, result

    base.monrun_output(check, code, message)


if __name__ == '__main__':
    main()
