#!/usr/bin/env bash

PKG_NAME="yb-trust-paysys"

. "/usr/share/${PKG_NAME}/service-functions.sh"

# Include additional environment, if necessary
source_host_env
#source_oracle_env

PKG_VER=$(get_venv_ver_active "$PKG_NAME")
VENV="${VENV:-$(get_venv_dir $PKG_NAME $PKG_VER)}"
${VENV}/bin/python > /dev/null 2>&1 <<EOF
import logging
logger = logging.getLogger(__name__)
from trust.scripts.graphite_metrics import App, ServantUWSGIMetric
App().collect_metrics([
        ServantUWSGIMetric(
            "yb-trust-paysys", metric_prefix="trust-lpm", cfg_name="lpm-servant"
        )
    ])
EOF
if (( $? != 0 )); then
  echo "2; Failed to send metrics to solomon"
else
  echo "0; Send metrics to solomon"
fi

