create or replace function MONITOR.CMV_MV_CONTENT return varchar2
is
v_res  varchar2(600);
record_counter integer;
begin

  for reco in (
     select CMV_OWNER || '.' || CMV_NAME as fname, CMV_OWNER, CMV_NAME from MONITOR.CMV_LIST
   )
  loop
    execute immediate 'select count(1) from '|| reco.fname ||' a join MONITOR.CMV_LIST b on A.CMV_CURR_PART = B.CMV_CURR_PART where rownum <=1
                         and b.cmv_owner=''' || reco.CMV_OWNER || ''' and b.cmv_name = ''' || reco.CMV_NAME || '''' into record_counter;
    if record_counter != 1 then
      v_res := v_res || reco.fname || ', ';
    end if;

  end loop;

  if (v_res is null) then
    v_res := '0;No CMVs with zero records';
  else
   v_res := substr(v_res, 0, length(v_res)-2);
   v_res := '2;CMVs with zero records: ' || v_res;
  end if;

  return v_res;
end;
/



update MONITOR.MONITOR_QUERY set SQL_QUERY=
'WITH
    source1 AS (SELECT monitor.chk_zero_mvs() obr FROM dual),
    source2 AS (SELECT monitor.cmv_mv_content obr FROM dual)
SELECT
     CASE
       WHEN SUBSTR(a.obr, 1, 1) + SUBSTR(b.obr, 1, 1) > 1 THEN ''2''
       ELSE ''0''
     END AS result,
     SUBSTR(a.obr, 3, 100) || ''; '' || SUBSTR(b.obr, 3, 100) message
FROM
    source1 a, source2 b'
where SERVICE='zero-record-mviews-meta';


commit;

