create or replace function MONITOR.CMV_MV_MON return varchar2
is
v_res  varchar2(600);
begin

  for reco in (
     select CMV_OWNER || '.' || CMV_NAME as fname
       from MONITOR.CMV_LIST
     where
       cmv_last_refresh_start + 1/24/60*cmv_refresh_mins + 1/24/60*cmv_refr_every_mins < sysdate  --не запустилось очередное обновление в пределах cmv_refr_every_mins
       or cmv_last_refresh_start + 1/24/60*cmv_refresh_mins < cmv_last_refresh_end  --обновление отработало и не уложилось в срок cmv_refresh_mins
       or (cmv_last_refresh_end < cmv_last_refresh_start and cmv_last_refresh_start + 1/24/60*cmv_refresh_mins < sysdate)   --обновление работает и не укалдывается в срок cmv_refresh_mins
   )
  loop
    v_res := v_res || reco.fname || ', ';
  end loop;

  if (v_res is null) then
    v_res := '0;0 failed CMVs';
  else
   v_res := substr(v_res, 0, length(v_res)-2);
   v_res := '2;Failed CMVs: ' || v_res;
  end if;

  return v_res;
end;
/

update MONITOR.MONITOR_QUERY set SQL_QUERY=
'WITH
    source1 AS (SELECT monitor.chk_mvs_sync() obr FROM  dual),
    source2 AS (SELECT monitor.cmv_mv_mon obr FROM dual)
SELECT
     CASE
       WHEN SUBSTR(a.obr, 1, 1) + SUBSTR(b.obr, 1, 1) > 1 THEN ''2''
       ELSE ''0''
     END AS result,
     SUBSTR(a.obr, 3, 100) || ''; '' || SUBSTR(b.obr, 3, 100) message
FROM
    source1 a, source2 b'
where SERVICE='matview-refresh';

commit;

