create or replace procedure system.CMV_REFRESH (v_owner in varchar2, v_name in varchar2)
IS
  v_work_p  number;
  v_cmv_parts number;
  v_sql   varchar2(4000);
  v_count  number;
  v_parallel  number;
  v_start_dt varchar2(64);
BEGIN

  select to_char(sysdate, 'YYYY-MM-DD hh24:mi:SS') into v_start_dt from dual;

    update MONITOR.CMV_LIST
     set cmv_last_refresh_start = sysdate
   where cmv_owner = v_owner and cmv_name = v_name;
  commit;

  --part to refresh
  select cmv_curr_part + 1, cmv_parts into v_work_p, v_cmv_parts from  MONITOR.CMV_LIST where cmv_owner = v_owner and cmv_name = v_name;
  if v_work_p > v_cmv_parts then
    v_work_p := 1;
  end if;

  --find if table subsubpartitioned
  select count(*) into v_count from dba_tab_subpartitions where table_owner = v_owner and table_name = v_name;


  --trunc table partition or subpartition
  if v_count > 0 then --trunc subpartitions
     for reco in (
        select 'alter table ' || table_owner || '.' || table_name || ' truncate subpartition ' || subpartition_name as v_sql
          from dba_tab_subpartitions where table_owner = v_owner and table_name = v_name and subpartition_position  = v_work_p)
     loop
       system.simple_logger.log_add('SYSTEM.CMV_REFRESH', v_owner || '.' || v_name || ': ' || reco.v_sql, 0);
       execute immediate reco.v_sql;
     end loop;
  else --trunc subpartition
     for reco in (
        select 'alter table ' || table_owner || '.' || table_name || ' truncate partition ' || partition_name as v_sql
          from dba_tab_partitions where table_owner = v_owner and table_name = v_name and partition_position  = v_work_p)
     loop
       system.simple_logger.log_add('SYSTEM.CMV_REFRESH', v_owner || '.' || v_name || ': ' || reco.v_sql, 0);
       execute immediate reco.v_sql;
     end loop;
  end if;

  --just for more visibility in system.simple_log
  DBMS_LOCK.sleep(2);

  --make index partition or subpartitions unusable
  if v_count > 0 then --unusable subpartitions
     for reco in (
        select 'alter index ' || a.owner || '.' || a.index_name || ' modify subpartition ' || subpartition_name || ' unusable' as v_sql
          from dba_indexes a join dba_ind_subpartitions b on a.owner = b.index_owner and a.index_name = b.index_name
         where a.table_name = v_name and a.table_owner = v_owner and subpartition_position = v_work_p)
     loop
       system.simple_logger.log_add('SYSTEM.CMV_REFRESH', v_owner || '.' || v_name || ': ' || reco.v_sql, 0);
       execute immediate reco.v_sql;
     end loop;
  else --unusable partition
     for reco in (
        select 'alter index ' || a.owner || '.' || a.index_name || ' modify partition ' || partition_name || ' unusable' as v_sql
          from dba_indexes a join dba_ind_partitions b on a.owner = b.index_owner and a.index_name = b.index_name
         where a.table_name = v_name and a.table_owner = v_owner and partition_position = v_work_p)
     loop
       system.simple_logger.log_add('SYSTEM.CMV_REFRESH', v_owner || '.' || v_name || ': ' || reco.v_sql, 0);
       execute immediate reco.v_sql;
     end loop;
  end if;

  --just for more visibility in system.simple_log
  DBMS_LOCK.sleep(2);

  --ins data
  select 'insert /*+ append parallel ('|| cmv_parallel ||') */ into ' ||  cmv_owner || '.' || cmv_name || ' ' ||
         replace (upper (cmv_text), 'SELECT', 'select cast('|| v_work_p ||' as number) as CMV_CURR_PART, ' )
   into v_sql
   from MONITOR.CMV_LIST where cmv_owner = v_owner and cmv_name = v_name;
  system.simple_logger.log_add('SYSTEM.CMV_REFRESH', v_owner || '.' || v_name || ': ' || v_sql, 0);
  execute immediate v_sql;
  commit;

  select cmv_parallel into v_parallel from MONITOR.CMV_LIST where cmv_owner = v_owner and cmv_name = v_name;

  --rebuild indexes
    if v_count > 0 then --rebuild subpartitions
     for reco in (
        select 'alter index ' || a.owner || '.' || a.index_name || ' rebuild subpartition ' || subpartition_name || ' parallel ' || v_parallel as v_sql
          from dba_indexes a join dba_ind_subpartitions b on a.owner = b.index_owner and a.index_name = b.index_name
         where a.table_name = v_name and a.table_owner = v_owner and subpartition_position = v_work_p)
     loop
       system.simple_logger.log_add('SYSTEM.CMV_REFRESH', v_owner || '.' || v_name || ': ' || reco.v_sql, 0);
       execute immediate reco.v_sql;
     end loop;
  else --rebuild partition
     for reco in (
        select 'alter index ' || a.owner || '.' || a.index_name || ' rebuild partition ' || partition_name  || ' parallel ' || v_parallel as v_sql
          from dba_indexes a join dba_ind_partitions b on a.owner = b.index_owner and a.index_name = b.index_name
         where a.table_name = v_name and a.table_owner = v_owner and partition_position = v_work_p)
     loop
       system.simple_logger.log_add('SYSTEM.CMV_REFRESH', v_owner || '.' || v_name || ': ' || reco.v_sql, 0);
       execute immediate reco.v_sql;
     end loop;
  end if;

  --gather stats for partition or subpartitions
  if v_count > 0 then --gather for subpartitions
     for reco in (
--        select 'begin DBMS_STATS.GATHER_TABLE_STATS (''' || table_owner || ''',''' || table_name || ''',''' || partition_name || ''', granularity => ''SUBPARTITION''); end;' as v_sql
        select 'begin DBMS_STATS.GATHER_TABLE_STATS (''' || table_owner || ''',''' || table_name || ''',''' || partition_name || ''', 
                          granularity => ''SUBPARTITION'', degree => ' || v_parallel || ', cascade => FALSE); end;' as v_sql
          from dba_tab_subpartitions where table_owner = v_owner and table_name = v_name and subpartition_position  = v_work_p)
     loop
       system.simple_logger.log_add('SYSTEM.CMV_REFRESH', v_owner || '.' || v_name || ': ' || reco.v_sql, 0);
       execute immediate reco.v_sql;
     end loop;
  else --gather for partition
     for reco in (
--        select 'begin DBMS_STATS.GATHER_TABLE_STATS (''' || table_owner || ''',''' || table_name || ''',''' || partition_name || '''); end;' as v_sql
        select 'begin DBMS_STATS.GATHER_TABLE_STATS (''' || table_owner || ''',''' || table_name || ''',''' || partition_name || ''',  degree => ' || v_parallel || ', cascade => FALSE ); end;' as v_sql
          from dba_tab_partitions where table_owner = v_owner and table_name = v_name and partition_position  = v_work_p)
     loop
       system.simple_logger.log_add('SYSTEM.CMV_REFRESH', v_owner || '.' || v_name || ': ' || reco.v_sql, 0);
       execute immediate reco.v_sql;
     end loop;
  end if;

  update MONITOR.CMV_LIST
     set cmv_curr_part = v_work_p,
         cmv_last_refresh_end = sysdate
   where cmv_owner = v_owner and cmv_name = v_name;
  commit;

  system.simple_logger.log_add('SYSTEM.CMV_REFRESH', v_owner || '.' || v_name || ': finished. Started at '||v_start_dt, 0);

  DBMS_LOCK.sleep(1);

/*
EXCEPTION
WHEN OTHERS THEN
  system.simple_logger.log_add('SYSTEM.CMV_REFRESH', v_owner || '.' || v_name || ': ' || SUBSTR(SQLERRM,1, 255), SQLCODE); */
END CMV_REFRESH;
/

grant execute on SYSTEM.CMV_REFRESH to BO;

