# DBCTL. Инструмент автоматического и полуавтоматического переключения мастер базы Oracle.

#### Что это и зачем?
- Содержит в себе все необходмые шаги для переключения базы
- Призван автоматизировать процесс переключения и исключить человеческие ошибки

#### Из чего состоит, где работает?
- Код написан на Python3
- Умеет собираться в аркадийный бинарь
- Может запускаться из любого места
- Файл projects.json содержит в себе описание всех нод всех кластеров с параметрами и последовательностью шагов для переключения.
- Файл steps.json содержит в себе описание всех выполняемых шагов с параметрами.

#### Как выполнить переключение мастера БД Oracle?
- Добавить все хосты (PRIMARY + STANDBY), всех кластеров для проекта в файл projects.json
- Перечислить все необходимые шаги, которые нужно выполнить, в спецификации хостов
- Шаги брать из файла steps.json, если каких-то не хватает, то добавить
- Выбрать опцию switchover указать два ДЦ которые будут участвовать в переключении, последовательность ДЦ не важна
- Указать environment и project они описаны в свойствах каждого хоста в файле projects.json 
- Указать флаг -dry_run. В итоге будет сформирован список с хостами и их свойствами, а также перечислены все шаги и их последовательность что будут выполняться в процессе переключения
- Провалидировать, глазами, что все ок, выполнить переключение, убрав флаг -dry_run

#### Требования
- Добавлены ssh ключи пользователя oracle между всеми нодами всех дц по проектно
- Корректный файл паролей на каждой ноде /etc/oracle-dbconf/secret/dba.conf
- Настроена конфигурация (The Data Guard command-line interface (DGMGRL) enables you to manage a Data Guard broker configuration and its databases directly from the command line, or from batch programs or scripts)

#### Установка
- Либо собрать бинарь из аркадии в Linux окружении, на Mac не пойдет.
- Либо выкачать проект, поставить зависимости (<b>pip3 install -r requirements.txt</b>) и запускать как обычный python скрипт

<code>
python3 dbctl.py -h<br>
usage: dbctl.py [-h] [-show_steps] [-switchover from_dc to_dc] [-single SINGLE] [-env ENV] [-prj PRJ] [-dry_run] [-manual]

optional arguments:<br>
  -h, --help            show this help message and exit<br>
  -show_steps           Showing the all steps<br>
  -switchover from_dc to_dc
                        Switchover database<br>
  -single SINGLE        Single step id<br>
  -env ENV              Environment<br>
  -prj PRJ              Project<br>
  -dry_run              Dry Run<br>
  -manual               Manual Run
</code>

#### Особенности
- У некоторых шагов, присутствует префикс after, он означает, что шаг будет выполняться после смены роли базы (switchover). Сделано для удобства админа. Роль у такого шага PHYSICAL STANDBY, хотя сами шаги предназначены для PRIMARY
- Приоритет и последовательность шагов, организована по id. Сделано это, чтобы максимально исключить человеческие ошибки
- Шаг будет выполнен или нет, определяется тем, на какой ноде включен, для какой роли включен и наличием флага <b>enabled</b>
- Шаг можно выключить глобально для всех, флаг <b>enabled</b> или просто не включать его в проект

#### Описание ключей
- show_steps. Выводит полный список шагов из steps.json
- switchover. Главная команда запуска процесса переключения. Инициирует процесс прохождения по всем шага. Последовательность ДЦ не важна
- single. Выполнение только одного шага
- env. Окружение к которому принадлежит проект
- prj. Проект к которому принадлежат хосты
- dry_run. Формирует фактические команды на выполнение и показывает на каких хостах будет их выполнять. Самого выполнения не происходит
- manual. Просит у админа подтверждение на выполнение каждой команды. Можно либо выполнить команду, либо пропустить ее

#### Рабочее сочетание ключей
- show_steps (покажет список шагов)
- switchover + env + prj (выполнит автоматически все шаги)
- switchover + env + prj + dry_run (покажет какие шаги готов выполнить, но не будет их выполнять)
- switchover + env + prj + manual (спросит про каждый шаг, выполнять или нет)
- switchover + env + prj + single (выполнит только один шаг, по указанному id)
