В этом репозитории лежат ansible playbooks для настроки докер-образов.

# Структура репозитория
## /
В корне лежат:

`common.yml` - плейбук, который применяется при сборке базового образа, а также при деплое образа (в этом случае выполняются только задачи, помеченные тегом deploy).

`app-appname.yml` - плейбук, применяющийся для сборки специфичного для конкретного приложения (в терминах platform) образа. appname - имя приложения в platform.

`appgroup-group.yml` - плейбук, применяющийся для сборки образа, специфичного для некой группы приложений. Обычно инклюдится в предыдущий файл.

`hosts` - inventory для ansible. Состоит из localhost, т.к. мы его используем только для билда контейнера.


## /roles
Тут лежат роли. Роли используются для разделения конфигов ansible на логические единицы. Предполагается, что эти логические единицы должны представлять настройку какого-либо одного сервиса с опциональными зависимостями от других сервисов. Так, например, почти все роли зависят от роли apt или apt-yandex, т.к. без настроеного apt или настроенных репозиториев яндекса дальнейшая установка пакетов не представляется возможной.

Также используется концепция, которую можно назвать "мета-роли". Это некие аггрегаты ролей, в которые другие роли аггрегируются с помощью зависимостей. Далее уже именно эти роли подключаются в playbook, лежащий в корне.

Ниже приблизительное описание, из чего состоит роль.

Примерная структура:

```
rolename/
    defaults/main.yml
    meta/main.yml
    tasks/
        main.yml
        users.yml
        configs.yml
        packages.yml
    templates/
        etc/rolename/app.conf
        usr/bin/some-script
```

* В файле `defaults/main.yml` содержатся переменные, которые подключаются с этой ролью.
Рекомендуется, чтобы переменные имели вид `rolename_scope_varname`, где scope - это, например, user, config или package (т.к. единственное число от названия файла в директории tasks).

* В файле `meta/main.yml` содержится информация о зависимостях.
Обычно все роли зависят от роли apt или apt-yandex (в зависимости от того, надо ли ставить яндексовые репозитории, или нет).

   Пример:

   ```
   dependencies:
     - { role: apt }
   ```
* В директории tasks основным является файл main.yml. В нём ничего не должно быть кроме include других файлов, в которых происходит настройка конфигов, выкатка пакетов или ещё что-то.
* В директории `templates/` хранятся все файлы и шаблоны, выкатываемые с помощью модуля `template`. Обратите внимение на 2 вещи:
    1. В этой директории путь до всех файлов относительно директории `templates/` всегда равен пути в контейнере относительно директории `/` + расширение файла .j2. Это сделано для удобства поиска этих файлов. Когда их становится много, единственный путь, когда в этой мешанине становится можно найти нужный файл, это пойти в таск и посмотреть там, что долго.
    2. Мы по умолчанию не пользуемся директорией `files/` и командой `copy`, потому что очень велика вероятность того, что статические файлы в процессе эволюции всё равно станут шаблонами и придется переделывать. Это нестрогое правило, могут быть исключения.

# Быстрый старт (для разработчиков)

Для каждого проекта заводится отдельный образ. Чтобы завети новый образ, необходимо [сделать тикет в очереди PAYSYSADMIN](https://st.yandex-team.ru/createTicket?queue=PAYSYSADMIN).
Чтобы долго не ждать, пока добавят новый образ, можно наследоваться от `paysys-base` образа и начать работу.
Потом просто сменить имя образа, когда поставленный тикет будет выполнен.

Чтобы приложение было запущено при старте контейнера, необходимо в образ положить свой `/run.sh`, из которого будет запускаться приложение.

# Визуализация дерева зависимостей

После создания новой роли полезно проанализировать дерево зависимостей, которое получилось. Для этого есть скрипт `show-dependency-tree.py`. Чтобы он заработал, нужно сделать:

```
pip install graphviz
pip install pyyaml
```


# Сборка базового образа для приложения

От базового образа будет наследоваться образ приложения.

```

; Получаем и собираем базовый образ
$ docker build -f Dockerfile.base-bionic .

; В ответ не предыдущую команду получим base_id, который используем в:
; name - псевдоним приложения (bcl, ift, refs), tag - метка версии (base, base1, base2)
$ docker build --build-arg APP_NAME=<name> --build-arg BASE_IMAGE=<base_id> -t registry.yandex.net/paysys/<name>:<tag> .

; Отправляем в репозиторий
$ docker push registry.yandex.net/paysys/<name>:<tag>

```
