#!/bin/bash
set -e

if [[ -n $(pgrep gpg-agent) ]]
then
    echo "Killing running gpg agent"
    pgrep gpg-agent | xargs kill
fi

for key in $(find /etc/yandex/balance-balalayka/private -name *.gpg | sort); do
    NEW_GPG_KEYS=($(gpg -v --dry-run --import ${key} 2>&1 \
        | grep -E 'gpg:\spub\s+?' | cut -d ' ' -f 4 |  cut -d '/' -f 2))
    for NEW_GPG_KEY in "${NEW_GPG_KEYS[@]}"; do
        if gpg --homedir /home/app/.gnupg/ --list-key ${NEW_GPG_KEY}
        then
            echo "GPG Key ${NEW_GPG_KEY} already exists, doing nothing"
        else
            if [[ ! -d /home/app/.gnupg/ ]]; then
                mkdir -p /home/app/.gnupg/
            fi
            gpg --batch --homedir /home/app/.gnupg/ --import ${key}
            echo "Marking GPG key ${NEW_GPG_KEY} as trusted"
            gpg --homedir /home/app/.gnupg/ --list-keys |
                awk '{ print $1":6" }' |
                grep ${NEW_GPG_KEY} |
                gpg --homedir /home/app/.gnupg/ --import-ownertrust
        fi
    done
done
chown -R app:app /home/app/.gnupg/
