#!/usr/bin/env python3
import os


def check_vars(variables_to_check):
    result = dict()
    for var in variables_to_check:
        if os.getenv('QLOUD_ENVIRONMENT') != "local":
            assert os.getenv(var), 'No required variable: {}'.format(var)
            result[var] = os.getenv(var)
    return result


if __name__ == '__main__':
    for k in check_vars([
        'MONGO_CLUSTER',
        'MONGO_MONITOR_PASS',
        'MONGO_MONITOR_USER',
        'MONGOS_PORT',
        'MONGO_CLUSTER_KEY'
    ]).items():
        print('{} {}'.format(*k))
