#!/usr/bin/env python3
import os


def check_vars(variables_to_check, optional=False):
    result = dict()
    for var in variables_to_check:
        if os.getenv('QLOUD_ENVIRONMENT') != "local":
            value = os.getenv(var)
            assert optional or value, 'No required variable: {}'.format(var)
            if value:
                result[var] = os.getenv(var)
    return result


def check_mutually_exclusive():
    if os.getenv('PAYSYS_PUSH_CLIENT_TOPIC') and \
       os.getenv('PAYSYS_PUSH_CLIENT_IDENT') and \
       os.getenv('QLOUD_ENVIRONMENT') != "local":
        assert False, '{} and {} are mutually exclusive'.format(
            'PAYSYS_PUSH_CLIENT_TOPIC',
            'PAYSYS_PUSH_CLIENT_IDENT'
        )


def main():
    result = dict()
    topic_vars = [
        'PAYSYS_PUSH_CLIENT_TOPIC',
        'PAYSYS_PUSH_CLIENT_TVM_SECRET',
        'PAYSYS_PUSH_CLIENT_TVM_CLIENT_ID',
        'PAYSYS_PUSH_CLIENT_TVM_SERVER_ID',
        'PAYSYS_PUSH_CLIENT_FILES',
        'PAYSYS_PUSH_CLIENT_MASTER_ADDR'
    ]
    ident_vars = [
        'PAYSYS_PUSH_CLIENT_FILES',
        'PAYSYS_PUSH_CLIENT_IDENT',
        'PAYSYS_PUSH_CLIENT_MASTER_ADDR'
    ]
    if os.getenv('PAYSYS_PUSH_CLIENT_IDENT'):
        result = check_vars(ident_vars)
    elif os.getenv('PAYSYS_PUSH_CLIENT_TOPIC') or os.getenv('QLOUD_ENVIRONMENT') == "local":
        result = check_vars(topic_vars)
    else:
        assert False, 'Set in environment one of two groups of variables:\n{}\n{}'.format(
            topic_vars,
            ident_vars
        )

    optional_vars = [
        'PAYSYS_PUSH_CLIENT_NETWORK_THREADS',
        'PAYSYS_PUSH_CLIENT_THREADS',
    ]
    result.update(check_vars(optional_vars, optional=True))

    if not result:
        result["PAYSYS_PUSH_CLIENT_MASTER_ADDR"] = "127.0.0.1"
        result["PAYSYS_PUSH_CLIENT_TVM_SECRET"] = "xxx"
        result["PAYSYS_PUSH_CLIENT_TVM_CLIENT_ID"] = "123"
        result["PAYSYS_PUSH_CLIENT_FILES"] = "/test:1"
        result["PAYSYS_PUSH_CLIENT_TOPIC"] = "test"
        result["PAYSYS_PUSH_CLIENT_TVM_SERVER_ID"] = "234"

    for k in result.items():
        print('{} {}'.format(*k))
    return result


if __name__ == '__main__':
    check_mutually_exclusive()
    main()
