#!/bin/bash
if [ -z "$1" ]
  then
    echo "usage: ./compare.sh <version_in_prod> <new_version>"
    exit 1;
fi

CURRENT=$1
NEW=$2
PACKAGES="yandex-card-proxy-card-form yandex-card-pyproxy-common yandex-card-pyproxy-keykeeper2 yandex-card-pyproxy-confpatch yandex-card-pyproxy-tokenizer yandex-card-pyproxy-scheduler yandex-card-pyproxy-keyapi yandex-card-pyproxy-scripts yandex-card-proxy-service yandex-card-pyproxy-admintools yandex-card-pyproxy-butils yandex-card-proxy-sql yandex-card-pyproxy-gostcrypto-wrapper yandex-card-pyproxy-gostcrypto-common yandex-card-pyproxy-admintools yandex-card-pyproxy-butils"
mkdir -p $HOME/${CURRENT}
mkdir -p $HOME/${NEW}
sudo apt-get update -qq


for package in $PACKAGES; do
	cd $HOME/${CURRENT}/
	apt-get download ${package}=${CURRENT}
	ar -x $HOME/${CURRENT}/${package}_${CURRENT}_all.deb data.tar.xz; tar xf  data.tar.xz && rm -f data.tar.xz
	cd $HOME/${NEW}
	apt-get download ${package}=${NEW}
	ar -x ${HOME}/${NEW}/${package}_${NEW}_all.deb data.tar.xz; tar xf  data.tar.xz && rm -f data.tar.xz
done

diff -ruBb $HOME/${CURRENT} $HOME/${NEW}
