import os
import sys
import requests
from urllib import quote_plus
from collections import OrderedDict

# https://wiki.yandex-team.ru/bot/api/oauth/
token = os.environ.get('BOT_TOKEN')
headers = {"Authorization": "OAuth {}".format(token)}
# https://st.yandex-team.ru/PLN-571#5f9c267ac9b8b244791ceb5c
# initially there is dict that look like this
#   inv_numbers = OrderedDict((
#       ("100136410", ("", "", ""))
#   ))
# first field is hostname
# second empty field is net of vlan333, you will know it by going by racktables link
# then - selecting found network switch and scrolling up to vlan333 network,
# after that - copy and paste it in first field.
#
# After finding network script will generate on next launch command
#   $ python /usr/lib/yandex/ark-tools/gen_ip.py --project_id 627
#     --project_id_location_prefix 2a02:6b8:c03:305::/64 --fqdn trust16f.paysys.yandex.ne
# and you need to copy paste ip in second parameter
#
# After that you launch it and edit dns zone
#   $ dns-client --zone-update --zone paysys.yandex.net --interactive --ask
#
# And after editing dns zones - reinstall machines
#
inv_numbers = OrderedDict((
    ("100136410", ("trust5e.paysys.yandex.net", "00:25:90:EB:FF:8E", "2a02:6b8:c04:1bd::/64", "2a02:6b8:c04:1bd:0:627:fe9:955e")),
    ("900381770", ("trust6e.paysys.yandex.net", "00:25:90:E5:48:52", "2a02:6b8:c04:172::/64", "2a02:6b8:c04:172:0:627:863e:4e86")),
    ("900386564", ("trust7e.paysys.yandex.net", "00:25:90:E4:CC:C2", "2a02:6b8:c04:219::/64", "2a02:6b8:c04:219:0:627:f4c0:cbb7")),
    ("900386608", ("trust8e.paysys.yandex.net", "00:25:90:E4:CC:3E", "2a02:6b8:c04:219::/64", "2a02:6b8:c04:219:0:627:6a86:43c4")),
    ("900392008", ("trust9e.paysys.yandex.net", "00:25:90:E4:2F:62", "2a02:6b8:c04:16e::/64", "2a02:6b8:c04:16e:0:627:bed2:1ea9")),

    ("900398362", ("trust10e.paysys.yandex.net", "00:25:90:E4:CF:66", "2a02:6b8:c04:235::/64", "2a02:6b8:c04:235:0:627:83b1:f264")),
    ("900895834", ("trust11e.paysys.yandex.net", "00:25:90:E4:CC:0A", "2a02:6b8:c04:235::/64", "2a02:6b8:c04:235:0:627:1afd:804f")),
    ("900902677", ("trust12e.paysys.yandex.net", "00:25:90:EB:95:EE", "2a02:6b8:c04:1c4::/64", "2a02:6b8:c04:1c4:0:627:ce60:e1f2")),
    ("900902693", ("trust13e.paysys.yandex.net", "00:25:90:EB:96:82", "2a02:6b8:c04:1bd::/64", "2a02:6b8:c04:1bd:0:627:4811:199c")),
    ("900902694", ("trust14e.paysys.yandex.net", "00:25:90:EB:96:8A", "2a02:6b8:c04:1bd::/64", "2a02:6b8:c04:1bd:0:627:542f:9882")),

    ("100114114", ("trust7f.paysys.yandex.net", "00:25:90:ED:32:30", "2a02:6b8:c03:789::/64", "2a02:6b8:c03:789:0:627:20d5:1da9")),
    ("100145716", ("trust8f.paysys.yandex.net", "00:25:90:EF:F9:70", "2a02:6b8:c03:731::/64", "2a02:6b8:c03:731:0:627:c531:1b4e")),
    ("100233466", ("trust9f.paysys.yandex.net", "40:8D:5C:34:FD:78", "2a02:6b8:c03:317::/64", "2a02:6b8:c03:317:0:627:4f5c:6e88")),
    ("100309044", ("trust10f.paysys.yandex.net", "A0:36:9F:34:C0:88", "2a02:6b8:c03:71b::/64", "2a02:6b8:c03:71b:0:627:2fe0:9882")),
    ("100309316", ("trust11f.paysys.yandex.net", "A0:36:9F:34:B7:54", "2a02:6b8:c03:71b::/64", "2a02:6b8:c03:71b:0:627:b8a2:2d56")),

    ("101102136", ("trust12f.paysys.yandex.net", "40:8D:5C:35:00:6F", "2a02:6b8:c03:317::/64", "2a02:6b8:c03:317:0:627:1a8f:c2e5")),
    ("101102142", ("trust13f.paysys.yandex.net", "40:8D:5C:34:FF:23", "2a02:6b8:c03:33f::/64", "2a02:6b8:c03:33f:0:627:b72e:40f8")),
    ("101102143", ("trust14f.paysys.yandex.net", "40:8D:5C:34:FF:19", "2a02:6b8:c03:305::/64", "2a02:6b8:c03:305:0:627:91a2:34e1")),
    ("101102174", ("trust15f.paysys.yandex.net", "40:8D:5C:34:FF:08", "2a02:6b8:c03:31e::/64", "2a02:6b8:c03:31e:0:627:83aa:b977")),
    ("101102325", ("trust16f.paysys.yandex.net", "40:8D:5C:34:FF:AE", "2a02:6b8:c03:305::/64", "2a02:6b8:c03:305:0:627:57a9:785c")),
))

inv_numbers_new = OrderedDict()


def get_url(inv_number):
    return "https://bot.yandex-team.ru/api/consistof.php?inv={}&format=json".format(inv_number)


def print_mac(mac):
    n = 2
    l = [mac[i:i+n] for i in range(0, len(mac), n)]
    return ':'.join(l)


def get_mac(res, first=False):
    mac = None
    has_second_nic = False
    for i in range(1, 3):
        if res.get('data').get('XXCSI_MACADDRESS{}'.format(i)):
            if mac and res.get('data').get('XXCSI_MACADDRESS{}'.format(i)):
                # this needed because setup.y-t.ru seems to choose mac address with lowest last hex digit
                old_mac_last = int(mac.split(":")[-1], 16)
                new_mac_lst = int(res.get('data').get('XXCSI_MACADDRESS{}'.format(i)).split(":")[-1], 16)
                if new_mac_lst > old_mac_last:
                    continue
            mac = res.get('data').get('XXCSI_MACADDRESS{}'.format(i))

    # for systems with two NIC
    if first:
        return print_mac(mac), True

    for i in res.get('data').get('Components'):
        # or it will choose separately installed network card
        if "XXCSI_MACADDRESS1" in i.keys():
            mac = i.get("XXCSI_MACADDRESS1")
            has_second_nic = True

    return print_mac(mac), has_second_nic


def get_fqdn(res):
    return res.get('data').get("XXCSI_FQDN")


for inv_number, settings in inv_numbers.iteritems():
    fqdn, mac, net, ip = settings
    if sys.argv[1] == "racktables":
        mac_ = mac
        res = requests.get(get_url(inv_number), headers=headers).json()
        fqdn = get_fqdn(res)
        mac, has_second_nic = get_mac(res)
        if mac_ != mac:
            print fqdn, mac, mac_, "not matched mac"
        print inv_number, fqdn, mac,\
            "https://racktables.yandex-team.ru/index.php?page=search&last_page=search&last_tab=default&q={}".format(
                quote_plus(mac)
            )
        continue

    if sys.argv[1] == "gen_ip":
        if not fqdn:
            res = requests.get(get_url(inv_number), headers=headers).json()
            fqdn = get_fqdn(res)

        print "python /usr/lib/yandex/ark-tools/gen_ip.py --project_id 627 " + \
              "--project_id_location_prefix {net} --fqdn {fqdn}".format(fqdn=fqdn, net=net)
        continue

    if sys.argv[1] == "dns":
        if not fqdn:
            res = requests.get(get_url(inv_number), headers=headers).json()
            fqdn = get_fqdn(res)
        print "{fqdn}.                  900  AAAA    {ip}".format(fqdn=fqdn, ip=ip)

    if sys.argv[1] == "config":
        res = requests.get(get_url(inv_number), headers=headers).json()
        fqdn = get_fqdn(res)
        print '("{inv_number}", ("{fqdn}", "{mac}", "{net}", "{ip}")),'.format(
            fqdn=fqdn, ip=ip, net=net, inv_number=inv_number, mac=mac
        )

    if sys.argv[1] == "salt_common_sls":
        dc = "none"
        if "f.paysys" in fqdn:
            dc = "myt"
        elif "e.paysys" in fqdn:
            dc = "iva"
        s = "  {fqdn}:\n" + \
              "    dc: {dc}\n" + \
              "    ipv6: {ip}\n" + \
              "    role:  []\n"
        print s.format(fqdn=fqdn, dc=dc, ip=ip)

    if sys.argv[1] == "netconfig":
        print "set -ex"

        res = requests.get(get_url(inv_number), headers=headers).json()
        fqdn = get_fqdn(res)
        mac, has_second_nic = get_mac(res)
        mac_second = None
        udev_rule_second = None
        udev_rule = '"SUBSYSTEM==\\\"net\\\", ACTION==\\\"add\\\", DRIVERS==\\\"?*\\\", ATTR{{address}}==\\\"{mac}\\\", ATTR{{dev_id}}==\\\"0x0\\\", ATTR{{type}}==\\\"1\\\", KERNEL==\\\"eth*\\\", NAME=\\\"eth{idx}\\\""'
        udev_rule_first = udev_rule.format(mac=mac.lower(), idx=0)
        executer = "executer -q -c exec {fqdn}".format(fqdn=fqdn)
        command = "{executer} 'cp /etc/network/interfaces /etc/network/interfaces.bkp'\n"
        command += "{executer} 'cp /etc/udev/rules.d/65-setup-persistent-net.rules " + \
                   "/etc/udev/rules.d/65-setup-persistent-net.rules.bkp'\n"
        command += "{executer} 'netconfig --fqdn {fqdn} > /etc/network/interfaces'\n"
        command += "{executer} 'echo {udev_rule_first} > /etc/udev/rules.d/65-setup-persistent-net.rules'\n"
        if has_second_nic:
            mac_second, has_second_nic = get_mac(res, first=True)
            udev_rule_second = udev_rule.format(mac=mac_second.lower(), idx=1)
            command += "{executer} 'echo {udev_rule_second} >> /etc/udev/rules.d/65-setup-persistent-net.rules'"

        print command.format(
            executer=executer, fqdn=fqdn, udev_rule_first=udev_rule_first, udev_rule_second=udev_rule_second
        )
